/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.dialog;

import fable.framework.internal.ICrystalSymmetryVarKeys;
import fable.framework.ui.rcp.Activator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CrystalSymmetryDialog
extends Dialog {
    private Combo spaceGroupSymbolCombo;
    private Shell shell;
    private Spinner spaceGroupSpinner;
    private static final int COMBO_BOX_WIDTH = 50;
    private Text spaceSystemText;
    private int spaceGroup = 1;
    private int spaceGroupSystem = 0;

    public CrystalSymmetryDialog(Shell shell, int n) {
        this(shell, 67680, n);
    }

    public CrystalSymmetryDialog(Shell shell, int n, int n2) {
        super(shell, n);
        this.setText("Space Group");
        this.spaceGroup = n2;
    }

    public int open() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new GridLayout(2, true));
        this.createContents((Composite)this.shell);
        this.shell.pack();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.spaceGroup;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite2);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("Symbol");
        this.spaceGroupSymbolCombo = new Combo(composite2, 28);
        this.spaceGroupSymbolCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(50, -1).applyTo((Control)this.spaceGroupSymbolCombo);
        this.spaceGroupSymbolCombo.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in the program");
        int n = 0;
        while (n < 230) {
            this.spaceGroupSymbolCombo.add(ICrystalSymmetryVarKeys.SPACE_GROUP_SYMBOLS[n]);
            ++n;
        }
        this.spaceGroupSymbolCombo.select(0);
        this.spaceGroupSymbolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CrystalSymmetryDialog.this.spaceGroup = CrystalSymmetryDialog.this.spaceGroupSymbolCombo.getSelectionIndex() + 1;
                CrystalSymmetryDialog.this.setSpaceGroup(CrystalSymmetryDialog.this.spaceGroup);
            }
        });
        composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite2);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("Number");
        this.spaceGroupSpinner = new Spinner(composite2, 2068);
        this.spaceGroupSpinner.setToolTipText("spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in the program");
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CrystalSymmetryDialog.this.spaceGroup = CrystalSymmetryDialog.this.spaceGroupSpinner.getSelection();
                CrystalSymmetryDialog.this.setSpaceGroup(CrystalSymmetryDialog.this.spaceGroup);
            }
        });
        composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)composite2);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("Crystal System:");
        this.spaceSystemText = new Text(composite2, 0);
        this.spaceSystemText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.spaceSystemText);
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
        this.spaceSystemText.setToolTipText("The crystal system is determined by the space group.");
        this.createButtons();
        this.setSpaceGroup(this.spaceGroup);
        return composite;
    }

    private void createButtons() {
        Image image;
        Image image2;
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Button button = new Button(composite, 24);
        button.setText("Ok");
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor("images/add.gif");
        if (imageDescriptor != null && (image2 = imageDescriptor.createImage()) != null) {
            button.setImage(image2);
        }
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CrystalSymmetryDialog.this.shell.close();
            }
        });
        image2 = new Button(composite, 24);
        image2.setText("Cancel");
        imageDescriptor = Activator.getImageDescriptor("images/delete.gif");
        if (imageDescriptor != null && (image = imageDescriptor.createImage()) != null) {
            image2.setImage(image);
        }
        image2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        image2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CrystalSymmetryDialog.this.spaceGroup = 0;
                CrystalSymmetryDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(button);
    }

    public void setSpaceGroup(int n) {
        this.spaceGroup = n;
        if (this.spaceGroupSymbolCombo.getSelectionIndex() != n - 1) {
            this.spaceGroupSymbolCombo.select(n - 1);
        }
        if (this.spaceGroupSpinner.getSelection() != n) {
            this.spaceGroupSpinner.setSelection(n);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (n <= ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        this.spaceGroupSystem = n2;
        this.spaceSystemText.setText(ICrystalSymmetryVarKeys.SPACE_GROUP_TYPES[this.spaceGroupSystem]);
    }
}

