/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.views.JmolView;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenJmolFileResource
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        IFile iFile = null;
        if (this.selection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)this.selection).iterator();
            while (iterator.hasNext()) {
                iFile = null;
                Object e = iterator.next();
                if (e instanceof IFile) {
                    iFile = (IFile)e;
                } else if (e instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)e).getAdapter(IFile.class);
                }
                if (iFile == null) continue;
                this.loadFile(iFile);
            }
        }
    }

    private void loadFile(IFile iFile) {
        if (iFile == null) {
            return;
        }
        IPath iPath = iFile.getLocation();
        String string = null;
        if (iPath != null) {
            string = iPath.toString();
        }
        if (string == null) {
            FableUtils.errMsg((Object)this, (String)"Cannot determine the path");
            return;
        }
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            FableUtils.errMsg((Object)this, (String)"Cannot determine the workbench window");
            return;
        }
        try {
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage == null) {
                FableUtils.errMsg((Object)this, (String)"Cannot determine the active page");
                return;
            }
            JmolView jmolView = (JmolView)iWorkbenchPage.findView(JmolView.getID());
            if (jmolView == null) {
                iWorkbenchPage.showView(JmolView.getID());
                jmolView = (JmolView)iWorkbenchPage.findView(JmolView.getID());
            }
            if (jmolView != null) {
                jmolView.openFile(string);
            } else {
                FableUtils.errMsg((Object)this, (String)"Failed to find JmolView");
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Failed to open JmolView", (Throwable)partInitException);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selection = iSelection;
    }
}

