/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.actions.ColumnEditorAction;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.views.FableIOConsole;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenColumnFileResourceAction
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        IFile iFile = null;
        if (this.selection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)this.selection).iterator();
            while (iterator.hasNext()) {
                iFile = null;
                Object e = iterator.next();
                if (e instanceof IFile) {
                    iFile = (IFile)e;
                } else if (e instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)e).getAdapter(IFile.class);
                }
                if (iFile == null) continue;
                this.loadFile(iFile);
            }
        }
    }

    private void loadFile(IFile iFile) {
        final IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            try {
                final String string = iFile.getLocation().toString();
                Job job = new Job("Load column file job " + string){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Please wait while loading file in editor " + string, -1);
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ColumnFileEditorInput columnFileEditorInput = new ColumnFileEditorInput(string);
                        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                        iProgressMonitor.done();
                        ColumnEditorAction.openEditors(columnFileEditorInput, iWorkbenchPage);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        if (iJobChangeEvent.getResult().isOK()) {
                            if (FableIOConsole.console != null) {
                                FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " completed successfully");
                            }
                        } else if (FableIOConsole.console != null) {
                            FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " did not complete successfully");
                        }
                    }
                });
            }
            catch (Exception exception) {
                FableUtils.excMsg((Object)this, (String)"Error opening ColFile", (Throwable)exception);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selection = iSelection;
    }
}

