/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.engine.PushStructuredOperation;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.PortableServer.Servant;

public class StructuredProxyPushSupplierImpl
extends AbstractProxySupplier
implements StructuredProxyPushSupplierOperations {
    private StructuredPushConsumer pushConsumer_;

    public StructuredProxyPushSupplierImpl(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_STRUCTURED;
    }

    public void deliverMessage(Message message) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deliverMessage() connected=" + this.isConnected() + " suspended=" + this.isSuspended() + " enabled=" + this.isEnabled());
        }
        if (this.isConnected()) {
            if (!this.isSuspended() && this.isEnabled()) {
                try {
                    this.pushConsumer_.push_structured_event(message.toStructuredEvent());
                }
                catch (Throwable throwable) {
                    PushStructuredOperation pushStructuredOperation = new PushStructuredOperation(this.pushConsumer_, message);
                    this.handleFailedPushOperation(pushStructuredOperation, throwable);
                }
            } else {
                this.enqueue(message);
            }
        } else {
            this.logger_.debug("Not connected");
        }
    }

    public void connect_structured_push_consumer(StructuredPushConsumer structuredPushConsumer) throws AlreadyConnected {
        this.assertNotConnected();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("connect structured_push_consumer");
        }
        this.pushConsumer_ = structuredPushConsumer;
        this.connectClient(structuredPushConsumer);
    }

    public void disconnect_structured_push_supplier() {
        this.dispose();
    }

    public void deliverPendingData() {
        Message[] messageArray = this.getAllMessages();
        if (messageArray != null) {
            for (int i = 0; i < messageArray.length; ++i) {
                this.deliverMessage(messageArray[i]);
                messageArray[i].dispose();
            }
        }
    }

    protected void connectionResumed() {
        this.scheduleDeliverPendingMessagesOperation_.run();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_structured_push_consumer();
        this.pushConsumer_ = null;
    }

    public List getSubsequentFilterStages() {
        return CollectionsWrapper.singletonList(this);
    }

    public MessageConsumer getMessageConsumer() {
        return this;
    }

    public boolean hasMessageConsumer() {
        return true;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new StructuredProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxySupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }
}

