/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractProxy
implements FilterAdminOperations,
QoSAdminOperations,
FilterStage,
Disposable,
ManageableServant,
Configurable {
    private MappingFilter nullMappingFilterRef_;
    protected boolean isIDPublic_;
    protected Logger logger_ = null;
    private SynchronizedBoolean connected_ = new SynchronizedBoolean(false);
    protected QoSPropertySet qosSettings_;
    protected Integer id_;
    protected AbstractAdmin admin_;
    protected OfferManager offerManager_;
    protected SubscriptionManager subscriptionManager_;
    protected Servant thisServant_;
    protected MappingFilter lifetimeFilter_;
    protected MappingFilter priorityFilter_;
    private FilterManager filterManager_;
    private SynchronizedBoolean disposed_ = new SynchronizedBoolean(false);
    private Runnable disposeHook_;
    private SynchronizedInt errorCounter_ = new SynchronizedInt(0);
    private POA poa_;
    private ORB orb_;
    private TaskProcessor taskProcessor_;
    private boolean isInterFilterGroupOperatorOR_;
    private boolean disposedProxyDisconnectsClient_;
    private Object client_;
    private SynchronizedBoolean active_ = new SynchronizedBoolean(true);
    protected ChannelContext channelContext_;

    AbstractProxy(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        this.admin_ = abstractAdmin;
        this.channelContext_ = channelContext;
        this.filterManager_ = new FilterManager(channelContext);
        this.setPOA(channelContext.getPOA());
        this.setORB(channelContext.getORB());
        this.setTaskProcessor(channelContext.getTaskProcessor());
        this.nullMappingFilterRef_ = MappingFilterHelper.narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)channelContext.getORB();
        this.configure(oRB.getConfiguration());
    }

    public void configure(Configuration configuration) {
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.disposedProxyDisconnectsClient_ = configuration.getAttribute("jacorb.notification.proxy.destroy_causes_disconnect", "on").equals("on");
        this.filterManager_.configure(configuration);
        this.qosSettings_ = new QoSPropertySet(configuration, 2);
    }

    public void setOfferManager(OfferManager offerManager) {
        this.offerManager_ = offerManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager_ = subscriptionManager;
    }

    public void setDisposeHook(Runnable runnable) {
        this.disposeHook_ = runnable;
    }

    public void setID(Integer n, boolean bl) {
        this.id_ = n;
        this.isIDPublic_ = bl;
    }

    public boolean isIDPublic() {
        return this.isIDPublic_;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setTaskProcessor(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }

    protected TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public void validate_event_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        throw new NO_IMPLEMENT();
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.set_qos(propertyArray);
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void priority_filter(MappingFilter mappingFilter) {
        this.priorityFilter_ = mappingFilter;
    }

    public MappingFilter priority_filter() {
        if (this.priorityFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.priorityFilter_;
    }

    public MappingFilter lifetime_filter() {
        if (this.lifetimeFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.lifetimeFilter_;
    }

    public void lifetime_filter(MappingFilter mappingFilter) {
        this.lifetimeFilter_ = mappingFilter;
    }

    public Integer getID() {
        return this.id_;
    }

    public final POA _default_POA() {
        return this.getPOA();
    }

    void setFilterManager(FilterManager filterManager) {
        this.filterManager_ = filterManager;
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public void deactivate() {
        this.logger_.info("deactivate Proxy");
        try {
            byte[] byArray = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this.logger_.fatalError("Couldn't deactivate Proxy", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDisconnectClient() {
        try {
            if (this.disposedProxyDisconnectsClient_ && this.isConnected()) {
                this.logger_.info("disconnect_client");
                this.disconnectClient();
            }
        }
        catch (Exception exception) {
            this.logger_.error("disconnect_client raised an unexpected error: ignore", exception);
        }
        finally {
            this.connected_.set(false);
        }
    }

    public boolean isDisposed() {
        return this.disposed_.get();
    }

    private void checkDisposalStatus() throws OBJECT_NOT_EXIST {
        if (this.disposed_.get()) {
            this.logger_.fatalError("dispose has been called twice");
            throw new OBJECT_NOT_EXIST();
        }
        this.disposed_.set(true);
    }

    public void dispose() {
        this.checkDisposalStatus();
        this.tryDisconnectClient();
        this.deactivate();
        this.remove_all_filters();
        this.disposeHook_.run();
    }

    public abstract ProxyType MyType();

    void setInterFilterGroupOperatorOR(boolean bl) {
        this.isInterFilterGroupOperatorOR_ = bl;
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.isInterFilterGroupOperatorOR_;
    }

    public boolean isConnected() {
        return this.connected_.get();
    }

    public boolean hasLifetimeFilter() {
        return this.lifetimeFilter_ != null;
    }

    public boolean hasPriorityFilter() {
        return this.priorityFilter_ != null;
    }

    public MappingFilter getLifetimeFilter() {
        return this.lifetimeFilter_;
    }

    public MappingFilter getPriorityFilter() {
        return this.priorityFilter_;
    }

    public void resetErrorCounter() {
        this.errorCounter_.set(0);
    }

    public int getErrorCounter() {
        return this.errorCounter_.get();
    }

    public int incErrorCounter() {
        return this.errorCounter_.increment();
    }

    protected boolean isSuspended() {
        return !this.active_.get();
    }

    public final void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.assertConnected();
        if (!this.active_.commit(true, false)) {
            throw new ConnectionAlreadyInactive();
        }
        this.connectionSuspended();
    }

    protected void connectionSuspended() {
    }

    public final void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.assertConnected();
        if (!this.active_.commit(false, true)) {
            throw new ConnectionAlreadyActive();
        }
        this.connectionResumed();
    }

    protected void connectionResumed() {
    }

    protected void assertConnected() throws NotConnected {
        if (!this.connected_.get()) {
            throw new NotConnected();
        }
    }

    protected void assertNotConnected() throws AlreadyConnected {
        if (this.connected_.get()) {
            throw new AlreadyConnected();
        }
    }

    protected void checkStillConnected() throws Disconnected {
        if (!this.connected_.get()) {
            this.logger_.fatalError("access on a not connected proxy");
            this.dispose();
            throw new Disconnected();
        }
    }

    protected void connectClient(Object object) {
        this.client_ = object;
        this.connected_.set(true);
    }

    public void preActivate() throws Exception {
    }

    protected abstract void disconnectClient();

    abstract Servant getServant();

    protected void handleDisconnected(Disconnected disconnected) {
        this.logger_.fatalError("Illegal state: Client think it's disconnected. Proxy thinks it's connected. The Proxy will be destroyed.", disconnected);
        this.dispose();
    }
}

