/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.common.CoGProperties;
import org.globus.gsi.gssapi.net.impl.GSIGssInputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssOutputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

class GSIAuth {
    GSIAuth(String password, Object gssCredential, String caLocations, Socket srbConnection, OutputStream out, InputStream in) throws IOException {
        this.sendGSIAuth(password, gssCredential, caLocations, srbConnection, out, in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendGSIAuth(String password, Object gssCredential, String caLocations, Socket srbConnection, OutputStream out, InputStream in) throws IOException {
        CoGProperties cog = null;
        String defaultCA = null;
        byte[] data = null;
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        GSSCredential credential = null;
        try {
            try {
                if (caLocations != null) {
                    cog = CoGProperties.getDefault();
                    defaultCA = cog.getCaCertLocations();
                    cog.setCaCertLocations(caLocations);
                }
                if (password == null) {
                    if (gssCredential == null) throw new IllegalArgumentException("Password/Proxyfile cannot be null.");
                    credential = (GSSCredential)gssCredential;
                } else if (password.startsWith("-----BEGIN CERTIFICATE-----")) {
                    data = password.getBytes();
                    credential = manager.createCredential(data, 0, 0, null, 0);
                } else {
                    LocalFile f = new LocalFile(password);
                    if (!f.exists()) {
                        throw new IOException("Proxy file path invalid");
                    }
                    GeneralRandomAccessFile inputFile = FileFactory.newRandomAccessFile(f, "r");
                    data = new byte[(int)f.length()];
                    inputFile.read(data);
                    inputFile.close();
                    credential = manager.createCredential(data, 0, 0, null, 0);
                }
                GSSContext context = null;
                GSIGssOutputStream gssout = null;
                GSIGssInputStream gssin = null;
                context = manager.createContext(null, null, credential, 0);
                context.requestCredDeleg(false);
                context.requestMutualAuth(true);
                GSIGssSocket ggSocket = new GSIGssSocket(srbConnection, context);
                gssout = new GSIGssOutputStream(out, context);
                gssin = new GSIGssInputStream(in, context);
                byte[] inToken = new byte[]{};
                byte[] outToken = null;
                while (!context.isEstablished()) {
                    outToken = context.initSecContext(inToken, 0, inToken.length);
                    if (outToken != null) {
                        gssout.writeToken(outToken);
                    }
                    if (context.isEstablished()) continue;
                    inToken = gssin.readHandshakeToken();
                }
            }
            catch (GSSException e) {
                SecurityException gsiException = null;
                String message = e.getMessage();
                if (message.indexOf("Invalid buffer") >= 0) {
                    gsiException = new SecurityException("GSI Authentication Failed - Invalid Proxy File");
                    gsiException.initCause(e);
                    throw gsiException;
                } else if (message.indexOf("Unknown CA") >= 0) {
                    gsiException = new SecurityException("GSI Authentication Failed - Cannot find Certificate Authority (CA)");
                    gsiException.initCause(e);
                    throw gsiException;
                } else {
                    gsiException = new SecurityException("GSI Authentication Failed");
                    gsiException.initCause(e);
                }
                throw gsiException;
            }
            catch (Throwable e) {
                SecurityException exception = new SecurityException("GSI Authentication Failed");
                exception.initCause(e);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            if (defaultCA == null) throw throwable;
            cog.setCaCertLocations(defaultCA);
            throw throwable;
        }
        if (defaultCA == null) return;
        cog.setCaCertLocations(defaultCA);
    }
}

