/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralMetaData;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.ProtocolCatalog;
import java.util.Arrays;
import java.util.HashMap;

public abstract class MetaDataSet
implements GeneralMetaData {
    protected static HashMap metaDataGroups = new HashMap();
    protected static HashMap metaDataFields = new HashMap();

    static {
        new ProtocolCatalog();
    }

    protected static void add(MetaDataGroup group) {
        metaDataGroups.put(group.getName(), group);
        MetaDataField[] fields = group.getFields();
        int i = 0;
        while (i < fields.length) {
            metaDataFields.put(fields[i].getName(), fields[i]);
            ++i;
        }
    }

    public static MetaDataGroup[] getMetaDataGroups() {
        return metaDataGroups.values().toArray(new MetaDataGroup[0]);
    }

    public static MetaDataGroup[] getMetaDataGroups(boolean sort) {
        if (!sort) {
            return MetaDataSet.getMetaDataGroups();
        }
        Object[] groups = MetaDataSet.getMetaDataGroups();
        Arrays.sort(groups);
        return groups;
    }

    public static MetaDataField getField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("The fieldName cannot be null.");
        }
        MetaDataField field = (MetaDataField)metaDataFields.get(fieldName);
        return field;
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, String value) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, float value) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, int value) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, int value1, int value2) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value1, value2);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, float value1, float value2) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value1, value2);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, String value1, String value2) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, value1, value2);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, int[] valueList) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, valueList);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, float[] valueList) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, valueList);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, String[] valueList) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, valueList);
    }

    public static MetaDataCondition newCondition(String fieldName, MetaDataTable table) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), table);
    }

    public static MetaDataCondition newCondition(String fieldName, int operator, MetaDataTable table) {
        return new MetaDataCondition(MetaDataSet.getField(fieldName), operator, table);
    }

    public static MetaDataCondition[] mergeConditions(MetaDataCondition condition1, MetaDataCondition condition2) {
        if (condition1 == null) {
            MetaDataCondition[] condition = new MetaDataCondition[]{condition2};
            return condition;
        }
        if (condition2 == null) {
            MetaDataCondition[] condition = new MetaDataCondition[]{condition1};
            return condition;
        }
        MetaDataCondition[] condition = new MetaDataCondition[]{condition1, condition2};
        return condition;
    }

    public static MetaDataCondition[] mergeConditions(MetaDataCondition condition1, MetaDataCondition[] condition2) {
        if (condition1 == null) {
            return condition2;
        }
        if (condition2 == null) {
            MetaDataCondition[] condition = new MetaDataCondition[]{condition1};
            return condition;
        }
        MetaDataCondition[] condition = new MetaDataCondition[condition2.length + 1];
        condition[0] = condition1;
        System.arraycopy(condition2, 0, condition, 1, condition2.length);
        return condition;
    }

    public static MetaDataCondition[] mergeConditions(MetaDataCondition[] condition1, MetaDataCondition[] condition2) {
        if (condition1 == null) {
            return condition2;
        }
        if (condition2 == null) {
            return condition1;
        }
        MetaDataCondition[] condition = new MetaDataCondition[condition1.length + condition2.length + 1];
        System.arraycopy(condition1, 0, condition, 0, condition1.length);
        System.arraycopy(condition2, 0, condition, condition1.length, condition2.length);
        return condition;
    }

    public static MetaDataSelect newSelection(String fieldName) {
        return new MetaDataSelect(MetaDataSet.getField(fieldName));
    }

    public static MetaDataSelect[] newSelection(String[] fieldNames) {
        MetaDataSelect[] selects = new MetaDataSelect[fieldNames.length];
        int i = 0;
        while (i < selects.length) {
            selects[i] = new MetaDataSelect(MetaDataSet.getField(fieldNames[i]));
            ++i;
        }
        return selects;
    }

    public static MetaDataSelect newSelection(String fieldName, int operation) {
        return new MetaDataSelect(MetaDataSet.getField(fieldName), operation);
    }

    public static MetaDataSelect[] newSelection(MetaDataGroup group) {
        MetaDataSelect[] selects = new MetaDataSelect[group.getFieldCount()];
        MetaDataField[] fieldList = group.getFields();
        int i = 0;
        while (i < selects.length) {
            selects[i] = new MetaDataSelect(fieldList[i]);
            ++i;
        }
        return selects;
    }

    public static MetaDataSelect[] mergeSelects(MetaDataSelect select1, MetaDataSelect select2) {
        if (select1 == null) {
            MetaDataSelect[] select = new MetaDataSelect[]{select2};
            return select;
        }
        if (select2 == null) {
            MetaDataSelect[] select = new MetaDataSelect[]{select1};
            return select;
        }
        MetaDataSelect[] select = new MetaDataSelect[]{select1, select2};
        return select;
    }

    public static MetaDataSelect[] mergeSelects(MetaDataSelect select1, MetaDataSelect[] select2) {
        if (select1 == null) {
            return select2;
        }
        if (select2 == null) {
            MetaDataSelect[] select = new MetaDataSelect[]{select1};
            return select;
        }
        MetaDataSelect[] select = new MetaDataSelect[select2.length + 1];
        select[0] = select1;
        System.arraycopy(select2, 0, select, 1, select2.length);
        return select;
    }

    public static MetaDataSelect[] mergeSelects(MetaDataSelect[] select1, MetaDataSelect[] select2) {
        if (select1 == null) {
            return select2;
        }
        if (select2 == null) {
            return select1;
        }
        MetaDataSelect[] select = new MetaDataSelect[select1.length + select2.length + 1];
        System.arraycopy(select1, 0, select, 0, select1.length);
        System.arraycopy(select2, 0, select, select1.length, select2.length);
        return select;
    }
}

