/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import java.util.Arrays;
import java.util.HashMap;

public class MetaDataGroup
implements Comparable {
    protected HashMap fields = new HashMap();
    protected String groupName;
    protected String description;

    public MetaDataGroup(String groupName, String description) {
        this.groupName = groupName;
        this.description = description;
    }

    public void add(MetaDataField field) {
        String fieldName = field.getName();
        if (this.isField(fieldName)) {
            MetaDataField oldField = this.getField(fieldName);
            oldField.addProtocol(field.getProtocol(0));
        } else {
            this.fields.put(fieldName, field);
        }
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public MetaDataField getField(String fieldName) {
        return (MetaDataField)this.fields.get(fieldName);
    }

    public MetaDataField[] getFields() {
        return this.fields.values().toArray(new MetaDataField[0]);
    }

    public MetaDataField[] getFields(boolean sort) {
        if (!sort) {
            return this.getFields();
        }
        Object[] mdFields = this.fields.values().toArray(new MetaDataField[0]);
        Arrays.sort(mdFields);
        return mdFields;
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    boolean isField(String fieldName) {
        return this.fields.get(fieldName) != null;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " : " + this.getDescription();
    }
}

