/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Protocol;

public final class MetaDataField
implements Comparable {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int STRING = 3;
    public static final int DATE = 4;
    public static final int TABLE = 14;
    private String fieldName;
    private String description;
    private int type;
    private String[] extensible;
    private Protocol[] protocols = new Protocol[1];

    public MetaDataField(String fieldName, String description, int type, Protocol protocol) {
        this.fieldName = fieldName;
        this.description = description;
        this.type = type;
        this.protocols[0] = protocol;
    }

    public MetaDataField(String fieldName, String description, int type, Protocol protocol, String extensibleName) {
        this.fieldName = fieldName;
        this.description = description;
        this.type = type;
        this.protocols[0] = protocol;
        if (extensibleName != null) {
            this.extensible = new String[1];
            this.extensible[0] = extensibleName;
        }
    }

    public String getName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    Protocol[] getProtocols() {
        return this.protocols;
    }

    Protocol getProtocol(int index) {
        return this.protocols[index];
    }

    public String getExtensibleName(Protocol protocol) {
        if (protocol != null && this.extensible != null) {
            int i = 0;
            while (i < this.protocols.length) {
                if (protocol.equals(this.protocols[i])) {
                    return this.extensible[i];
                }
                ++i;
            }
        }
        return null;
    }

    boolean isExtensible(Protocol protocol) {
        if (this.extensible == null) {
            return false;
        }
        int i = 0;
        while (i < this.protocols.length) {
            if (this.protocols[i].equals(protocol) && this.extensible[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean usesProtocol(Protocol protocol) {
        int i = 0;
        while (i < this.protocols.length) {
            if (this.protocols[i].equals(protocol)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addProtocol(Protocol protocol) {
        int i = 0;
        while (i < this.protocols.length) {
            if (this.protocols[i].equals(protocol)) {
                return;
            }
            ++i;
        }
        Protocol[] temp = this.protocols;
        this.protocols = new Protocol[temp.length + 1];
        System.arraycopy(temp, 0, this.protocols, 0, temp.length);
        this.protocols[temp.length] = protocol;
    }

    public void addProtocol(Protocol protocol, String extensibleName) {
        this.addProtocol(protocol);
        if (this.extensible == null) {
            this.extensible = new String[1];
            this.extensible[0] = extensibleName;
        } else {
            int i = 0;
            while (i < this.protocols.length) {
                if (this.protocols[i].equals(protocol)) {
                    this.extensible[i] = extensibleName;
                    return;
                }
                ++i;
            }
        }
    }

    public boolean equals(Object obj) {
        MetaDataField field = null;
        if (obj == null) {
            return false;
        }
        try {
            field = (MetaDataField)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        Protocol[] protocol = field.getProtocols();
        String extensibleName = null;
        String extensibleName2 = null;
        if (this.fieldName == field.getName() && this.description == field.getDescription() && this.type == field.getType()) {
            if (this.extensible != null) {
                int i = 0;
                while (i < protocol.length) {
                    extensibleName = this.getExtensibleName(protocol[i]);
                    extensibleName2 = field.getExtensibleName(protocol[i]);
                    if (extensibleName != null ? !extensibleName.equals(extensibleName2) : extensibleName2 != null && extensibleName == null) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.fieldName) + ": " + this.description;
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }
}

