/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.BinaryDataFormat;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.Host;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public abstract class GeneralRandomAccessFile
implements DataOutput,
DataInput {
    public static final int SEEK_START = 0;
    public static final int SEEK_CURRENT = 1;
    public static final int SEEK_END = 2;
    protected int fd = -1;
    protected int rw;
    protected BinaryDataFormat fileFormat;
    protected boolean swapNeeded;
    protected boolean isClosed;
    protected GeneralFile file;

    public GeneralRandomAccessFile(GeneralFile file, String mode) throws IOException, SecurityException {
        int imode = -1;
        this.file = file;
        this.file.createNewFile();
        this.rwCheck(this.file, mode);
        this.fileFormat = new BinaryDataFormat();
    }

    public void finalize() throws IOException {
        this.close();
    }

    protected void rwCheck(GeneralFile file, String mode) throws IllegalArgumentException, SecurityException {
        if ((mode = mode.toLowerCase()).equals("r")) {
            this.rw = 0;
        } else if (mode.equals("rw")) {
            this.rw = 1;
        } else if (mode.equals("rws")) {
            this.rw = 2;
        } else if (mode.equals("rwd")) {
            this.rw = 3;
        } else {
            throw new IllegalArgumentException("Illegal mode \"" + mode + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        if (!file.canRead()) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
        if (this.rw > 0 && !file.canWrite()) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
    }

    public int getFD() {
        if (this.fd != -1) {
            return this.fd;
        }
        throw new IllegalArgumentException("No file descriptor available.");
    }

    public GeneralFile getFile() {
        return this.file;
    }

    protected abstract void open(GeneralFile var1) throws IOException;

    public abstract int read() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] b, int offset, int len) throws IOException {
        return this.readBytes(b, offset, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int offset, int len) throws IOException {
        int count;
        int inc = 0;
        do {
            if ((count = this.read(b, offset + inc, len - inc)) >= 0) continue;
            throw new EOFException();
        } while ((inc += count) < len);
    }

    public int skipBytes(int n) throws IOException {
        long length;
        if (n <= 0) {
            return 0;
        }
        long position = this.getFilePointer();
        long newPosition = position + (long)n;
        if (newPosition > (length = this.length())) {
            newPosition = length;
        }
        this.seek(newPosition);
        return (int)(newPosition - position);
    }

    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.writeBytes(buffer, 0, buffer.length);
    }

    protected abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        this.writeBytes(b, offset, len);
    }

    public void write(String text) throws IOException {
        this.writeBytes(text.getBytes(), 0, text.length());
    }

    public abstract long getFilePointer() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract void seek(long var1, int var3) throws IOException;

    public abstract long length() throws IOException;

    public abstract void setLength(long var1) throws IOException;

    public abstract void close() throws IOException;

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean readBoolean() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value != 0;
    }

    public byte readByte() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return (byte)value;
    }

    public int readUnsignedByte() throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value;
    }

    public short readShort() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getShortSize());
        return this.fileFormat.shortValue(bytes);
    }

    public int readUnsignedShort() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getShortSize());
        return this.fileFormat.unsignedShortValue(bytes);
    }

    public char readChar() throws IOException {
        int t;
        int s = this.read();
        if ((s | (t = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((s << 8) + (t << 0));
    }

    public int readInt() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getIntSize());
        return this.fileFormat.intValue(bytes);
    }

    public long readUnsignedInt() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getIntSize());
        return this.fileFormat.unsignedIntValue(bytes);
    }

    public long readLong() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongSize());
        return this.fileFormat.longValue(bytes);
    }

    public long readUnsignedLong() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongSize());
        return this.fileFormat.unsignedLongValue(bytes);
    }

    public long readUnsignedLongLong() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongLongSize());
        return this.fileFormat.unsignedLongLongValue(bytes);
    }

    public long readLongLong() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongLongSize());
        return this.fileFormat.longLongValue(bytes);
    }

    public double readLongDouble() throws IOException, EOFException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getLongDoubleSize());
        return this.fileFormat.longDoubleValue(bytes);
    }

    public float readFloat() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getFloatSize());
        return this.fileFormat.floatValue(bytes);
    }

    public double readDouble() throws EOFException, IOException {
        byte[] bytes = new byte[64];
        this.readFully(bytes, 0, this.fileFormat.getDoubleSize());
        return this.fileFormat.doubleValue(bytes);
    }

    public String readLine() throws IOException {
        char ch = (char)this.read();
        StringBuffer line = new StringBuffer();
        while (ch != '\n' && ch != '\r' && ch != '\uffff') {
            line.append(ch);
            ch = (char)this.read();
        }
        if (ch == '\r' && this.read() != 10) {
            this.seek(this.getFilePointer());
        } else if (ch == '\uffffffff' && line.length() == 0) {
            return null;
        }
        return line.toString();
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeShort(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeChar(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeShort(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeInt(int v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeInt(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLong(long v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeLong(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLongLong(long v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeLongLong(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLongDouble(double v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeLongDouble(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeFloat(float v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeFloat(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeDouble(double v) throws IOException {
        byte[] bytes = new byte[64];
        int nBytes = this.fileFormat.encodeDouble(v, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeBytes(String s) throws IOException {
        this.writeBytes(s.getBytes(), 0, s.length());
    }

    public void writeChars(String s) throws IOException {
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            this.writeChar(chars[i]);
            ++i;
        }
    }

    public void writeUTF(String str) throws IOException {
    }

    public void setBinaryDataFormat(BinaryDataFormat bdf) {
        if (bdf == null) {
            return;
        }
        this.fileFormat = bdf;
        this.swapNeeded = this.fileFormat.isMBFByteOrder() != Host.isMBFByteOrder();
    }

    public BinaryDataFormat getBinaryDataFormat() {
        return this.fileFormat;
    }

    public void readBooleans(boolean[] values, int nValues) throws EOFException, IOException {
        byte[] bytes = new byte[nValues];
        this.readFully(bytes, 0, nValues);
        int i = 0;
        while (i < nValues) {
            values[i] = bytes[i] != 0;
            ++i;
        }
    }

    public void readDoubles(double[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getDoubleSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.doubleValues(bytes, values, nValues);
    }

    public void readFloats(float[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getFloatSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.floatValues(bytes, values, nValues);
    }

    public void readInts(int[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getIntSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.intValues(bytes, values, nValues);
    }

    public void readLongs(long[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getLongSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.longValues(bytes, values, nValues);
    }

    public void readLongDoubles(double[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getLongDoubleSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.longDoubleValues(bytes, values, nValues);
    }

    public void readLongLongs(long[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getLongLongSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.longLongValues(bytes, values, nValues);
    }

    public void readShorts(short[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getShortSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.shortValues(bytes, values, nValues);
    }

    public void readUnsignedShorts(short[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getShortSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.unsignedShortValues(bytes, values, nValues);
    }

    public void readUnsignedInts(int[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getIntSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.unsignedIntValues(bytes, values, nValues);
    }

    public void readUnsignedLongs(long[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getLongSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.unsignedLongValues(bytes, values, nValues);
    }

    public void readUnsignedLongLongs(long[] values, int nValues) throws EOFException, IOException {
        int nBytes = nValues * this.fileFormat.getLongLongSize();
        byte[] bytes = new byte[nBytes];
        this.readFully(bytes, 0, nBytes);
        this.fileFormat.unsignedLongLongValues(bytes, values, nValues);
    }

    public void writeBooleans(boolean[] values, int nValues) throws IOException {
        byte[] bytes = new byte[nValues];
        int i = 0;
        while (i < nValues) {
            bytes[i] = !values[i] ? (byte)0 : 1;
            ++i;
        }
        this.write(bytes, 0, nValues);
    }

    public void writeDoubles(double[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getDoubleSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeDoubles(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeFloats(float[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getFloatSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeFloats(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeInts(int[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getIntSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeInts(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLongs(long[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getLongSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeLongs(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeShorts(short[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getShortSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeShorts(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLongLongs(long[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getLongLongSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeLongLongs(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }

    public void writeLongDoubles(double[] values, int nValues) throws IOException {
        int nBytes = nValues * this.fileFormat.getLongDoubleSize();
        byte[] bytes = new byte[nBytes];
        this.fileFormat.encodeLongDoubles(values, nValues, bytes);
        this.write(bytes, 0, nBytes);
    }
}

