/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MetaDataDisplay
extends JTable {
    static final int TEXT_PADDING = 4;
    GeneralFileSystem fileSystem;
    private GeneralFile[] queryObj;
    private MetaDataRecordList[] rl;
    private MetaDataTable table;
    boolean keyValue = true;
    static int fontPixelHeight = -1;
    static Font font;
    static FontMetrics fontMetrics;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void setKeyValue(boolean keyValuePair) {
        this.keyValue = keyValuePair;
    }

    boolean getKeyValue() {
        return this.keyValue;
    }

    public MetaDataDisplay(MetaDataRecordList recordList) {
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = recordList;
        this.initComponents();
    }

    public MetaDataDisplay(MetaDataRecordList[] recordList) {
        this.rl = recordList;
        this.initComponents();
    }

    public MetaDataDisplay(GeneralFile file, MetaDataRecordList recordList) {
        this.queryObj = new GeneralFile[1];
        this.queryObj[0] = file;
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = recordList;
        this.initComponents();
    }

    public MetaDataDisplay(GeneralFileSystem fileSystem, MetaDataRecordList[] recordList) {
        this.fileSystem = fileSystem;
        this.rl = recordList;
        this.queryObj = new GeneralFile[this.rl.length];
        this.initComponents();
    }

    MetaDataDisplay(MetaDataTable table) {
        this.table = table;
        this.initComponents();
    }

    private void initComponents() {
        if (this.rl != null) {
            String fileName = null;
            String directory = null;
            Object temp = null;
            this.createResultsTable(this.rl);
            if (this.fileSystem != null) {
                int i = 0;
                while (i < this.rl.length) {
                    temp = this.rl[i].getValue("file name");
                    if (temp != null) {
                        fileName = temp.toString();
                        temp = this.rl[i].getValue("directory name");
                        if (temp != null) {
                            directory = temp.toString();
                            this.queryObj[i] = FileFactory.newFile(this.fileSystem, directory, fileName);
                        }
                    }
                    ++i;
                }
            }
        } else if (this.table != null) {
            MetaDataDisplay.createMetaDataTable(this.table);
        }
    }

    public MetaDataRecordList[] getRecordLists() {
        return this.rl;
    }

    static int adjustColumnSizes(JTable table) {
        TableModel model = table.getModel();
        TableColumn column = null;
        int columnCount = table.getColumnCount();
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int totalWidth = 4;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < columnCount) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            if (fontMetrics == null) {
                font = comp.getFont();
                if (font == null) {
                    font = new Font("SansSerif", 0, 12);
                    comp.setFont(font);
                }
                fontMetrics = comp.getFontMetrics(font);
            }
            headerWidth = comp.getPreferredSize().width + 4;
            int oldWidth = 0;
            int testRows = table.getRowCount();
            int j = 0;
            while (j < testRows) {
                Object value = table.getValueAt(j, i);
                oldWidth = cellWidth;
                if (value == null) {
                    cellWidth = 1;
                } else if (value instanceof String) {
                    cellWidth = MetaDataDisplay.getCellWidth(value.toString());
                } else if (value instanceof Integer) {
                    cellWidth = MetaDataDisplay.getCellWidth(value.toString());
                } else if (value instanceof Long) {
                    cellWidth = MetaDataDisplay.getCellWidth(value.toString());
                } else if (value instanceof Float) {
                    cellWidth = MetaDataDisplay.getCellWidth(value.toString());
                } else if (value instanceof Date) {
                    cellWidth = MetaDataDisplay.getCellWidth(value.toString());
                } else if (value instanceof JTable) {
                    cellWidth = MetaDataDisplay.adjustColumnSizes((JTable)value);
                }
                cellWidth = Math.max(cellWidth, oldWidth);
                ++j;
            }
            cellWidth = Math.max(headerWidth, cellWidth);
            column.setPreferredWidth(cellWidth);
            totalWidth += cellWidth;
            cellWidth = 0;
            ++i;
        }
        return totalWidth;
    }

    private static int getCellWidth(String value) {
        int w = fontMetrics.stringWidth(value);
        if (fontPixelHeight <= 0) {
            fontPixelHeight = fontMetrics.getHeight();
        }
        return w + 4;
    }

    private void createResultsTable(MetaDataRecordList[] rl) {
        if (rl == null) {
            return;
        }
        int definableRows = 0;
        boolean column = false;
        int fieldsLength = rl[0].getFieldCount();
        int recordListLength = rl.length;
        String[] fields = new String[fieldsLength];
        Object[][] data = new Object[recordListLength][fieldsLength];
        int tempFieldsLength = 0;
        int i = 0;
        while (i < fieldsLength) {
            switch (rl[0].getFieldType(i)) {
                case 14: {
                    if (this.keyValue) {
                        MetaDataTable subTable = rl[0].getTableValue(i);
                        String[] tempFields = new String[(tempFieldsLength += fieldsLength + subTable.getRowCount()) - 1];
                        System.arraycopy(fields, 0, tempFields, 0, fieldsLength);
                        int j = fieldsLength;
                        while (j < tempFieldsLength) {
                            tempFields[j - 1] = subTable.getStringValue(j - fieldsLength, 0);
                            ++j;
                        }
                        fields = tempFields;
                        break;
                    }
                    fields[i] = rl[0].getFieldName(i);
                    break;
                }
                default: {
                    fields[i] = rl[0].getFieldName(i);
                }
            }
            ++i;
        }
        i = 0;
        while (i < recordListLength) {
            int j = 0;
            while (j < fieldsLength) {
                if (rl[i].getFieldCount() > j) {
                    switch (rl[i].getFieldType(j)) {
                        case 14: {
                            if (this.keyValue) {
                                MetaDataTable subTable = rl[i].getTableValue(j);
                                Object[] tempData = new Object[tempFieldsLength];
                                System.arraycopy(data[i], 0, tempData, 0, fieldsLength);
                                int k = fieldsLength;
                                while (k < tempFieldsLength) {
                                    tempData[k - 1] = subTable.getStringValue(k - fieldsLength, 1);
                                    ++k;
                                }
                                data[i] = tempData;
                                break;
                            }
                            data[i][j] = MetaDataDisplay.createMetaDataTable(rl[i].getTableValue(j));
                            definableRows += rl[i].getTableValue(j).getRowCount();
                            break;
                        }
                        default: {
                            data[i][j] = rl[i].getStringValue(j);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        MetaDataTableModel model = new MetaDataTableModel(data, fields);
        this.setModel(model);
        if (!this.keyValue) {
            this.setDefaultRenderer(JTable.class, new MetaDataTableCellRenderer(this.getDefaultRenderer(JTable.class)));
        }
        this.setDefaultRenderer(String.class, new MetaDataTableCellRenderer(this.getDefaultRenderer(String.class)));
        if (this.queryObj != null) {
            if (!this.keyValue) {
                this.setDefaultEditor(JTable.class, new MetaDataTableCellEditor(model, this.getDefaultEditor(JTable.class)));
            }
            this.setDefaultEditor(String.class, new MetaDataTableCellEditor(model, this.getDefaultEditor(String.class)));
        }
        if (definableRows > 1) {
            int columnWidth = MetaDataDisplay.adjustColumnSizes(this);
            int columnHeight = (data.length + 1 + (definableRows -= 2)) * fontPixelHeight;
            this.setPreferredScrollableViewportSize(new Dimension(columnWidth, columnHeight * 2));
            this.setRowHeight(columnHeight);
        } else {
            int columnWidth = MetaDataDisplay.adjustColumnSizes(this);
            int columnHeight = fontPixelHeight;
            this.setPreferredScrollableViewportSize(new Dimension(columnWidth, columnHeight));
            this.setRowHeight(columnHeight);
        }
    }

    static JTable createMetaDataTable(MetaDataTable table) {
        int tableRows = table.getRowCount();
        int tableColumns = table.getColumnCount();
        Object[][] temp = new Object[tableRows][tableColumns];
        String value = null;
        Object[][] subData = null;
        int k = 0;
        int maxK = 0;
        int ii = 0;
        while (ii < tableRows) {
            int jj = 0;
            while (jj < tableColumns) {
                value = table.getStringValue(ii, jj);
                if (value != null && !value.equals("")) {
                    temp[ii][k] = value;
                    ++k;
                } else {
                    temp[ii][k] = "";
                }
                ++jj;
            }
            maxK = Math.max(k, maxK);
            k = 0;
            ++ii;
        }
        subData = new Object[tableRows][maxK];
        ii = 0;
        while (ii < tableRows) {
            System.arraycopy(temp[ii], 0, subData[ii], 0, maxK);
            ++ii;
        }
        JTable jTable = new JTable(subData, subData[0]);
        Font font = jTable.getFont();
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
            jTable.setFont(font);
        }
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        int columnWidth = 0;
        int columnHeight = (tableRows + 1) * fontMetrics.getHeight();
        jTable.setPreferredScrollableViewportSize(new Dimension(columnWidth, columnHeight * 2));
        jTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                TableModel model = (TableModel)e.getSource();
                String columnName = model.getColumnName(column);
                Object data = model.getValueAt(row, column);
            }
        });
        return jTable;
    }

    static /* synthetic */ MetaDataRecordList[] access$0(MetaDataDisplay metaDataDisplay) {
        return metaDataDisplay.rl;
    }

    static /* synthetic */ GeneralFile[] access$1(MetaDataDisplay metaDataDisplay) {
        return metaDataDisplay.queryObj;
    }

    class MetaDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private TableCellEditor defaultEditor;
        Object component;
        String originalValue;
        int currentRow = -1;
        int currentColumn = -1;

        public MetaDataTableCellEditor(TableModel model, TableCellEditor editor) {
            this.defaultEditor = editor;
            this.addCellEditorListener(new CellEditorListener(this, model){
                final /* synthetic */ MetaDataTableCellEditor this$1;
                private final /* synthetic */ TableModel val$model;
                {
                    this.this$1 = metaDataTableCellEditor;
                    this.val$model = tableModel;
                }

                public void editingCanceled(ChangeEvent e) {
                }

                public void editingStopped(ChangeEvent e) {
                    MetaDataRecordList[] tempRL = new MetaDataRecordList[1];
                    try {
                        if (this.this$1.getCellEditorValue() instanceof JTable) {
                            JTable table = (JTable)this.this$1.getCellEditorValue();
                            int rows = table.getRowCount();
                            int columns = table.getColumnCount();
                            String[][] temp = new String[rows][columns];
                            int[] op = new int[rows];
                            Object t = null;
                            int i = 0;
                            while (i < rows) {
                                int j = 0;
                                while (j < columns) {
                                    t = table.getValueAt(i, j);
                                    if (t != null) {
                                        temp[i][j] = t.toString();
                                    }
                                    ++j;
                                }
                                op[i] = 0;
                                ++i;
                            }
                            MetaDataTable mdt = new MetaDataTable(op, temp);
                            tempRL[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), mdt);
                            if (MetaDataDisplay.access$1(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow] != null) {
                                MetaDataDisplay.access$1(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].modifyMetaData(tempRL[0]);
                            }
                        } else if (this.this$1.getCellEditorValue() instanceof JTextField) {
                            JTextField textField = (JTextField)this.this$1.getCellEditorValue();
                            String text = textField.getText();
                            if (!text.equals(this.this$1.originalValue)) {
                                Object value = MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].getValue(this.this$1.currentColumn);
                                if (value instanceof MetaDataTable) {
                                    MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].setValue(this.this$1.currentColumn, (MetaDataTable)value);
                                    tempRL[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), (MetaDataTable)value);
                                } else {
                                    MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].setValue(this.this$1.currentColumn, text);
                                    tempRL[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$0(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), text);
                                }
                                this.val$model.setValueAt(value, this.this$1.currentRow, this.this$1.currentColumn);
                                if (MetaDataDisplay.access$1(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow] != null) {
                                    MetaDataDisplay.access$1(MetaDataTableCellEditor.access$0(this.this$1))[this.this$1.currentRow].modifyMetaData(tempRL[0]);
                                }
                            }
                        } else if (this.this$1.getCellEditorValue() instanceof String) {
                            System.out.println("getCellEditorValue- String " + this.this$1.getCellEditorValue());
                        }
                    }
                    catch (SRBException t) {
                        t.printStackTrace();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.defaultEditor != null) {
                this.defaultEditor = null;
            }
            if (this.component != null) {
                this.component = null;
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.component = value;
            this.currentRow = row;
            this.currentColumn = column;
            if (value instanceof String) {
                this.component = new JTextField((String)value);
                this.originalValue = (String)value;
            } else {
                this.component = this.defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            return (Component)this.component;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public Object getCellEditorValue() {
            return this.component;
        }

        public void addCellEditorListener(CellEditorListener l) {
            super.addCellEditorListener(l);
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
        }

        public boolean isCellEditable(EventObject anEvent) {
            return super.isCellEditable(anEvent);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            super.removeCellEditorListener(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return super.shouldSelectCell(anEvent);
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        static /* synthetic */ MetaDataDisplay access$0(MetaDataTableCellEditor metaDataTableCellEditor) {
            return metaDataTableCellEditor.MetaDataDisplay.this;
        }
    }

    class MetaDataTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer __defaultRenderer;
        private TableCellEditor defaultEditor;

        public MetaDataTableCellRenderer(TableCellRenderer renderer) {
            this.__defaultRenderer = renderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JComponent) {
                return (JComponent)value;
            }
            return this.__defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class MetaDataTableModel
    extends AbstractTableModel {
        Object[][] data;
        private String[] names;
        static /* synthetic */ Class class$0;

        MetaDataTableModel(Object[][] data, String[] names) {
            this.data = data;
            this.names = names;
        }

        public String getColumnName(int column) {
            return this.names[column];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.names.length;
        }

        public Object getValueAt(int row, int column) {
            while (column >= this.data[row].length) {
                --column;
            }
            return this.data[row][column];
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            while (column >= this.data[0].length) {
                --column;
            }
            Object obj = this.getValueAt(0, column);
            if (obj != null) {
                return obj.getClass();
            }
            return String.class;
        }

        public void setValueAt(Object value, int row, int column) {
            if (row < this.data.length && column < this.data[row].length) {
                this.data[row][column] = value;
            }
        }
    }
}

