/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.gui.MetaDataDisplay;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeCellEditor;

public class JargonTreeCellEditor
implements TreeCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private JComponent currentComponent;
    static /* synthetic */ Class class$0;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.listenerList != null) {
            this.listenerList = null;
        }
        if (this.currentComponent != null) {
            this.currentComponent = null;
        }
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return this.currentComponent;
    }

    public boolean isCellEditable(EventObject e) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof String) {
            this.currentComponent = value.equals(JargonTreeModel.TOP_LEVEL) ? new JLabel((String)value, JargonTreeModel.FOLDER_ICON, 0) : (leaf ? new JLabel((String)value, JargonTreeModel.FILE_ICON, 0) : new JLabel((String)value, JargonTreeModel.FOLDER_ICON, 0));
        } else if (value instanceof LocalFile) {
            this.currentComponent = leaf ? new JLabel(((LocalFile)value).getName(), JargonTreeModel.FILE_ICON, 0) : new JLabel(((LocalFile)value).getName(), JargonTreeModel.FOLDER_ICON, 0);
        } else {
            JargonTreeModel model = (JargonTreeModel)tree.getModel();
            GeneralFile file = (GeneralFile)value;
            MetaDataRecordList[] rl = new MetaDataRecordList[]{model.getMetaDataRecordList(file)};
            if (rl[0] == null) {
                if (leaf) {
                    if (file instanceof SRBFile) {
                        rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), file.getName());
                        rl[0].addRecord(SRBMetaDataSet.getField("directory name"), file.getParent());
                    }
                } else if (file instanceof SRBFile) {
                    rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("directory name"), file.getAbsolutePath());
                }
            }
            this.currentComponent = new MetaDataDisplay(file, rl[0]);
            JScrollPane jScrollPane = new JScrollPane(this.currentComponent);
            Dimension d = this.currentComponent.getPreferredSize();
            d.setSize(d.width, d.height + MetaDataDisplay.fontPixelHeight + 4);
            jScrollPane.setPreferredSize(d);
            return jScrollPane;
        }
        return this.currentComponent;
    }
}

