/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters;

import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAdapter
extends AbstractNodeAdapter<SimpleNode> {
    private Name getter;
    private Name setter;
    private Name delete;
    private SimpleNode doc;

    public PropertyAdapter(ModuleAdapter module, AbstractScopeNode<?> parent, SimpleNode node, AdapterPrefs adapterPrefs) {
        super(module, parent, node, adapterPrefs);
        if (this.nodeHelper.isAssign((SimpleNode)this.getASTNode())) {
            this.initByAssign();
        }
    }

    private void initByAssign() {
        this.getter = null;
        this.setter = null;
        this.delete = null;
        this.doc = null;
        exprType[] args = this.getPropertyArgs();
        int i = 0;
        while (i < args.length) {
            this.setMethod(args[i], i);
            ++i;
        }
        keywordType[] keywordTypeArray = this.getValue().keywords;
        int n = this.getValue().keywords.length;
        int n2 = 0;
        while (n2 < n) {
            keywordType keyword = keywordTypeArray[n2];
            this.setKeyword(keyword);
            ++n2;
        }
        if (this.getter == null) {
            this.getter = this.createNone();
        }
        if (this.setter == null) {
            this.setter = this.createNone();
        }
        if (this.delete == null) {
            this.delete = this.createNone();
        }
    }

    private void setKeyword(keywordType kw) {
        if (this.nodeHelper.isFGet(kw)) {
            this.getter = (Name)kw.value;
        } else if (this.nodeHelper.isFSet(kw)) {
            this.setter = (Name)kw.value;
        } else if (this.nodeHelper.isFDel(kw)) {
            this.delete = (Name)kw.value;
        } else if (this.nodeHelper.isKeywordStr(kw)) {
            this.doc = kw;
        }
    }

    private Name createNone() {
        return new Name("None", 6, true);
    }

    private void setMethod(exprType expr, int i) {
        if (this.nodeHelper.isStr((SimpleNode)expr)) {
            this.doc = expr;
        } else if (this.nodeHelper.isName((SimpleNode)expr)) {
            Name name = (Name)expr;
            switch (i) {
                case 0: {
                    this.getter = name;
                    break;
                }
                case 1: {
                    this.setter = name;
                    break;
                }
                case 2: {
                    this.delete = name;
                    break;
                }
                case 3: {
                    if (this.nodeHelper.isNone((SimpleNode)name)) break;
                    this.doc = name;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown value");
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.nodeHelper.getName((SimpleNode)this.getTarget());
    }

    public boolean isComplete() {
        return this.hasGetter() && this.hasSetter() && this.hasDelete() && this.hasDocString();
    }

    public boolean hasSetter() {
        return !this.nodeHelper.isNone((SimpleNode)this.setter);
    }

    public boolean hasDelete() {
        return !this.nodeHelper.isNone((SimpleNode)this.delete);
    }

    public boolean hasDocString() {
        return this.doc != null;
    }

    public boolean hasGetter() {
        return !this.nodeHelper.isNone((SimpleNode)this.getter);
    }

    private Assign getAssign() {
        return (Assign)this.getASTNode();
    }

    private exprType[] getPropertyArgs() {
        return this.getValue().args;
    }

    private Name getTarget() {
        return (Name)this.getAssign().targets[0];
    }

    private Call getValue() {
        return (Call)this.getAssign().value;
    }
}

