/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer;

import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.util.ImageUtility;
import de.jreality.writer.VRMLWriterHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.WeakHashMap;

public class WriterVRML {
    private boolean useDefs = true;
    private boolean drawTubes = false;
    private boolean drawSpheres = false;
    private boolean moveLightsToSceneRoot = true;
    private boolean writeTextureFiles = false;
    private VRMLWriterHelper wHelp = new VRMLWriterHelper();
    private DefaultGeometryShader dgs;
    private DefaultPolygonShader dps;
    private DefaultLineShader dls;
    private DefaultPointShader dvs;
    private DefaultTextShader dpts;
    private DefaultTextShader dlts;
    private DefaultTextShader dvts;
    private String fileStem = String.format("texture-%10d-", System.currentTimeMillis());
    private static final int PER_VERTEX = 0;
    private static final int PER_PART = 1;
    private static final int PER_FACE = 2;
    private static final int OVERALL = 3;
    private PrintWriter out = null;
    private static final String spacing = "  ";
    private static String hist = "";
    String writePath = "";
    WeakHashMap<ImageData, String> textureMaps = new WeakHashMap();
    int textureCount = 0;

    public WriterVRML(OutputStream outS) {
        this.out = new PrintWriter(outS);
    }

    public WriterVRML(FileWriter outS) {
        this.out = new PrintWriter(outS);
    }

    public WriterVRML(PrintWriter outS) {
        this.out = outS;
    }

    public static void write(SceneGraphComponent sceneRoot, FileOutputStream stream) {
        WriterVRML writer = new WriterVRML(stream);
        writer.write(sceneRoot);
    }

    public void setWritePath(String path) {
        this.writePath = path;
        if (!this.writePath.endsWith("/")) {
            this.writePath = this.writePath + "/";
        }
    }

    public void write(SceneGraphNode sgn) {
        this.out.println("#VRML V1.0 ascii");
        if (this.useDefs) {
            this.wHelp.inspect(sgn);
        }
        if (this.moveLightsToSceneRoot) {
            this.out.println("" + hist + "Separator { # collected lights and sceneRoot");
            String oldhist = hist;
            hist = hist + spacing;
            sgn.accept(new MyLightVisitor());
            sgn.accept(new MyVisitor());
            hist = oldhist;
            this.out.println("" + hist + "}");
        } else {
            sgn.accept(new MyVisitor());
        }
        this.out.flush();
    }

    private void updateShaders(EffectiveAppearance eap) {
        this.dgs = ShaderUtility.createDefaultGeometryShader(eap);
        if (this.dgs.getPointShader() instanceof DefaultPointShader) {
            this.dvs = (DefaultPointShader)this.dgs.getPointShader();
            this.dvts = this.dvs.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dvs.getTextShader() : null;
        } else {
            this.dvs = null;
        }
        if (this.dgs.getLineShader() instanceof DefaultLineShader) {
            this.dls = (DefaultLineShader)this.dgs.getLineShader();
            this.dlts = this.dls.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dls.getTextShader() : null;
        } else {
            this.dls = null;
        }
        if (this.dgs.getPolygonShader() instanceof DefaultPolygonShader) {
            this.dps = (DefaultPolygonShader)this.dgs.getPolygonShader();
            this.dpts = this.dps.getTextShader() instanceof DefaultTextShader ? (DefaultTextShader)this.dps.getTextShader() : null;
        } else {
            this.dps = null;
        }
    }

    private void writeGeoFaces(IndexedFaceSet f, String hist) {
        String[] labels;
        double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(f, Attribute.COORDINATES);
        if (coords == null) {
            return;
        }
        this.writeCoordinates(coords, hist);
        if (this.dps.getSmoothShading().booleanValue()) {
            double[][] vNormals = VRMLWriterHelper.getDoubleDoubleVertexAttr(f, Attribute.NORMALS);
            if (vNormals != null) {
                this.writeNormalBinding(0, hist);
                this.writeNormals(vNormals, hist);
            }
        } else {
            double[][] fNormals = VRMLWriterHelper.getDoubleDoubleFaceAttr(f, Attribute.NORMALS);
            if (fNormals != null) {
                this.writeNormalBinding(2, hist);
                this.writeNormals(fNormals, hist);
            }
        }
        double[][] fColors = VRMLWriterHelper.getDoubleDoubleFaceAttr(f, Attribute.COLORS);
        if (fColors != null) {
            this.writeMaterialBinding(2, hist);
            this.writeColors(fColors, hist);
        } else {
            double[][] vColors = VRMLWriterHelper.getDoubleDoubleVertexAttr(f, Attribute.COLORS);
            if (vColors != null) {
                this.writeMaterialBinding(0, hist);
                this.writeColors(vColors, hist);
            }
        }
        this.out.println(hist + "IndexedFaceSet { # " + f.getName());
        int[][] indices = VRMLWriterHelper.getIntIntFaceAttr(f, Attribute.INDICES);
        if (indices != null) {
            this.writeIndices(indices, hist + spacing);
        }
        this.out.println(hist + "}");
        if (this.dpts.getShowLabels().booleanValue() && (labels = VRMLWriterHelper.getLabelPointAttr(f)) != null) {
            this.writeFaceLabels(coords, indices, labels, hist);
        }
    }

    private void writeGeoLines(IndexedLineSet l, String hist) {
        String[] labels;
        double[][] lcoords = VRMLWriterHelper.getDoubleDoubleVertexAttr(l, Attribute.COORDINATES);
        int[][] lindices = VRMLWriterHelper.getIntIntEdgeAttr(l, Attribute.INDICES);
        if (lcoords == null) {
            return;
        }
        this.writeCoordinates(lcoords, hist);
        double[][] lColors = VRMLWriterHelper.getDoubleDoubleEdgeAttr(l, Attribute.COLORS);
        if (lColors != null) {
            this.writeMaterialBinding(1, hist);
            this.writeColors(lColors, hist);
        } else {
            double[][] vColors = VRMLWriterHelper.getDoubleDoubleVertexAttr(l, Attribute.COLORS);
            if (vColors != null) {
                this.writeMaterialBinding(0, hist);
                this.writeColors(vColors, hist);
            }
        }
        this.out.println(hist + "IndexedLineSet { # " + l.getName());
        this.writeIndices(lindices, hist + spacing);
        this.out.println(hist + "}");
        if (this.dlts.getShowLabels().booleanValue() && (labels = VRMLWriterHelper.getLabelEdgeAttr(l)) != null) {
            this.writeEdgeLabels(lcoords, lindices, labels, hist);
        }
    }

    private void writeGeoPoints(PointSet p, String hist) {
        String[] labels;
        double[][] coords = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COORDINATES);
        if (coords == null) {
            return;
        }
        this.writeCoordinates(coords, hist);
        double[][] vColors = VRMLWriterHelper.getDoubleDoubleVertexAttr(p, Attribute.COLORS);
        if (vColors != null) {
            this.writeMaterialBinding(0, hist);
            this.writeColors(vColors, hist);
        }
        this.out.println(hist + "PointSet { # " + p.getName());
        this.out.println(hist + spacing + "numPoints " + p.getNumPoints());
        this.out.println(hist + "}");
        if (this.dvts.getShowLabels().booleanValue() && (labels = VRMLWriterHelper.getLabelPointAttr(p)) != null) {
            this.writeLabelsAtPoints(coords, labels, hist);
        }
    }

    private void writeCoordinates(double[][] points, String hist) {
        this.out.println(hist + "Coordinate3 { point [");
        String hist2 = hist + spacing;
        if (points[0].length == 4) {
            points = Pn.dehomogenize(points, points);
        }
        for (int i = 0; i < points.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(points[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeNormals(double[][] normals, String hist) {
        this.out.println(hist + "Normal { vector  [");
        String hist2 = hist + spacing;
        if (normals[0].length == 4) {
            normals = Pn.dehomogenize(normals, normals);
        }
        for (int i = 0; i < normals.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(normals[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeColors(double[][] Colors, String hist) {
        this.out.println(hist + "Material { ");
        this.out.println(hist + spacing + "diffuseColor  [");
        String hist2 = hist + spacing + spacing;
        for (int i = 0; i < Colors.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(Colors[i], hist2, ",", 3, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeMaterialBinding(int binding, String hist) {
        this.out.print(hist + "MaterialBinding { value ");
        if (binding == 0) {
            this.out.println("PER_VERTEX }");
        } else if (binding == 2) {
            this.out.println("PER_FACE }");
        } else if (binding == 1) {
            this.out.println("PER_PART }");
        } else if (binding == 3) {
            this.out.println("OVERALL }");
        } else {
            this.out.println("DEFAULT }");
        }
    }

    private void writeNormalBinding(int binding, String hist) {
        this.out.print(hist + "NormalBinding { value ");
        if (binding == 0) {
            this.out.println("PER_VERTEX }");
        } else if (binding == 2) {
            this.out.println("PER_FACE }");
        } else {
            this.out.println("DEFAULT }");
        }
    }

    private void writeTexture(Texture2D tex, String hist) {
        String hist2 = hist + spacing;
        this.out.println(hist + "Texture2 {");
        if (this.writeTextureFiles) {
            String fileName = this.textureMaps.get(tex.getImage());
            if (fileName == null) {
                fileName = this.fileStem + String.format("%04d", this.textureCount) + ".png";
                String fullName = this.writePath + fileName;
                ++this.textureCount;
                ImageUtility.writeBufferedImage(new File(fullName), (BufferedImage)tex.getImage().getImage());
                this.textureMaps.put(tex.getImage(), fileName);
            }
            this.out.println(hist + "filename " + "\"" + fileName + "\" ");
        } else {
            VRMLWriterHelper.writeImage(tex, hist2, this.out);
        }
        this.out.print(hist + "wrapS ");
        this.writeTexWrap(tex.getRepeatS());
        this.out.print(hist + "wrapT ");
        this.writeTexWrap(tex.getRepeatT());
        this.out.println(hist + "}");
        this.writeTexTrans(hist2, tex);
    }

    private void writeTexWrap(int wrap) {
        switch (wrap) {
            case 33071: {
                System.out.println("texture wrap:only clamp & repeat are supported");
            }
            case 10496: {
                this.out.println("CLAMP");
                break;
            }
            case 33648: {
                System.out.println("texture wrap:only clamp & repeat are supported");
            }
            case 10497: {
                this.out.println("REPEAT");
                break;
            }
        }
    }

    private void writeFaceLabels(double[][] coords, int[][] indis, String[] labs, String hist) {
        double[][] centers = new double[indis.length][3];
        for (int i = 0; i < indis.length; ++i) {
            int k;
            int j;
            int[] face = indis[i];
            double[] midpoint = new double[]{0.0, 0.0, 0.0};
            for (j = 0; j < face.length; ++j) {
                for (k = 0; k < 3; ++k) {
                    int n = k;
                    midpoint[n] = midpoint[n] + coords[face[j]][k];
                }
            }
            for (k = 0; k < 3; ++k) {
                centers[i][k] = midpoint[k] / (double)j;
            }
        }
        this.writeLabelsAtPoints(centers, labs, hist);
    }

    private void writeEdgeLabels(double[][] coords, int[][] indis, String[] labs, String hist) {
        double[][] centers = new double[indis.length][3];
        for (int i = 0; i < indis.length; ++i) {
            int[] firstEdge = indis[i];
            for (int k = 0; k < 3; ++k) {
                centers[i][k] = coords[indis[i][0]][k] / 2.0 + coords[indis[i][1]][k] / 2.0;
            }
        }
        this.writeLabelsAtPoints(centers, labs, hist);
    }

    private void writeLabelsAtPoints(double[][] centers, String[] labs, String hist) {
        for (int i = 0; i < centers.length; ++i) {
            this.out.println(hist + "Translation { translation ");
            VRMLWriterHelper.writeDoubleArray(centers[i], "", " }", 3, this.out);
            this.out.println(hist + "AsciiText { width 1 string \"" + labs[i] + "\"}");
            this.out.println(hist + "Translation { translation ");
            VRMLWriterHelper.writeDoubleArray(new double[]{-centers[i][0], -centers[i][1], -centers[i][2]}, "", " }", 3, this.out);
        }
    }

    private void writeDoubleMatrix(double[] d, int width, int depth, String hist) {
        d = Rn.transpose(null, d);
        double[] n = new double[width];
        for (int i = 0; i < depth; ++i) {
            System.arraycopy(d, i * width, n, 0, 4);
            VRMLWriterHelper.writeDoubleArray(n, hist, "", n.length, this.out);
        }
    }

    private void writeInfoString(String info, String hist) {
        this.out.println(hist + "Info { string \"" + info + "\" }");
    }

    private void writeIndices(int[][] in, String hist) {
        this.out.println(hist + "coordIndex [");
        for (int i = 0; i < in.length; ++i) {
            int le = in[i].length;
            this.out.print(hist + spacing);
            for (int j = 0; j < le; ++j) {
                this.out.print("" + in[i][j] + ", ");
            }
            this.out.println(" -1, ");
        }
        this.out.println(hist + "]");
    }

    private void writeMaterial(Color a, Color d, Color s, double t, String hist) {
        String hist2 = hist + spacing;
        this.out.println(hist + "Material { ");
        if (a != null) {
            this.out.println(hist2 + "ambientColor " + VRMLWriterHelper.ColorToString(a));
        }
        if (d != null) {
            this.out.println(hist2 + "diffuseColor " + VRMLWriterHelper.ColorToString(d));
        }
        if (s != null) {
            this.out.println(hist2 + "specularColor " + VRMLWriterHelper.ColorToString(s));
        }
        if (t != 0.0) {
            this.out.println(hist2 + "transparency " + t);
        }
        this.out.println(hist + "}");
    }

    private void writeTexTrans(String hist, Texture2D tex) {
        String hist2 = hist + spacing;
        Matrix mat = tex.getTextureMatrix();
        FactoredMatrix matrix = new FactoredMatrix(mat.getArray());
        double[] trans = matrix.getTranslation();
        double ang = matrix.getRotationAngle();
        double[] rotA = matrix.getRotationAxis();
        double[] scale = matrix.getStretch();
        this.out.println(hist + "Texture2Transform {");
        this.out.println(hist2 + "translation  " + trans[0] / trans[3] + " " + trans[1] / trans[3]);
        this.out.println(hist2 + "rotation  " + ang);
        this.out.println(hist2 + "scaleFactor " + scale[0] + " " + scale[1]);
        this.out.println(hist2 + "center 0 0");
        this.out.println(hist + "}");
    }

    private void writeTexCoords(double[][] texCoords, String hist) {
        String hist2 = hist + spacing;
        this.out.println(hist + "TextureCoordinate2 { point [");
        for (int i = 0; i < texCoords.length; ++i) {
            VRMLWriterHelper.writeDoubleArray(texCoords[i], hist2, ",", 2, this.out);
        }
        this.out.println(hist + "]}");
    }

    private void writeDirLight(DirectionalLight l, String hist, PrintWriter out, double[] dir) {
        double di = l.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(l.getColor());
        out.println(hist + "DirectionalLight { # " + l.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        if (dir == null) {
            out.println(hist + "direction  0 0 1");
        } else {
            out.print(hist + "direction ");
            VRMLWriterHelper.writeDoubleArray(dir, "", "", 3, out);
        }
        hist = oldHist;
        out.println(hist + "}");
    }

    private void writePointLight(PointLight l, String hist, PrintWriter out, double[] location) {
        double di = l.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(l.getColor());
        out.println(hist + "PointLight { # " + l.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        if (location != null) {
            out.print(hist + "location ");
            VRMLWriterHelper.writeDoubleArray(location, "", "", 3, out);
        }
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        hist = oldHist;
        out.println(hist + "}");
    }

    private void writeSpotLight(SpotLight li, String hist, PrintWriter out, double[] location, double[] dir) {
        double di = li.getIntensity();
        double[] dc = VRMLWriterHelper.colorToDoubleArray(li.getColor());
        out.println(hist + "SpotLight { # " + li.getName());
        String oldHist = hist;
        hist = hist + spacing;
        out.println(hist + "intensity " + di);
        out.print(hist + "color ");
        VRMLWriterHelper.writeDoubleArray(dc, "", "", 3, out);
        if (location != null) {
            out.print(hist + "location ");
            VRMLWriterHelper.writeDoubleArray(location, "", "", 3, out);
        }
        out.println(hist + "dropOffRate 0");
        if (dir != null) {
            out.print(hist + "direction ");
            VRMLWriterHelper.writeDoubleArray(dir, "", "", 3, out);
        }
        out.println(hist + "cutOffAngle " + li.getConeAngle());
        hist = oldHist;
        out.println(hist + "}");
    }

    public void setWriteTextureFiles(boolean writeTextureFiles2) {
        this.writeTextureFiles = writeTextureFiles2;
    }

    public boolean isWriteTextureFiles() {
        return this.writeTextureFiles;
    }

    public boolean isDrawSpheres() {
        return this.drawSpheres;
    }

    public boolean isDrawTubes() {
        return this.drawTubes;
    }

    public boolean isMoveLightsToSceneRoot() {
        return this.moveLightsToSceneRoot;
    }

    public boolean isUseDefs() {
        return this.useDefs;
    }

    public void setDrawSpheres(boolean drawSpheres) {
        this.drawSpheres = drawSpheres;
    }

    public void setDrawTubes(boolean drawTubes) {
        this.drawTubes = drawTubes;
    }

    public void setUseDefs(boolean useDefs) {
        this.useDefs = useDefs;
    }

    public void setMoveLightsToSceneRoot(boolean moveLightsToSceneRoot) {
        this.moveLightsToSceneRoot = moveLightsToSceneRoot;
    }

    private class MyLightVisitor
    extends SceneGraphVisitor {
        SceneGraphPath p = new SceneGraphPath();

        public void visit(SceneGraphComponent c) {
            if (!c.isVisible()) {
                return;
            }
            this.p.push(c);
            c.childrenAccept(this);
            super.visit(c);
            this.p.pop();
        }

        public void visit(DirectionalLight l) {
            FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
            fm.update();
            double[] dir = fm.getRotation().multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
            WriterVRML.this.writeDirLight(l, hist, WriterVRML.this.out, dir);
            super.visit(l);
        }

        public void visit(PointLight l) {
            if (!(l instanceof SpotLight)) {
                FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
                fm.update();
                double[] c = fm.getTranslation();
                if (c != null) {
                    c = new double[]{c[0], c[1], c[2]};
                }
                WriterVRML.this.writePointLight(l, hist, WriterVRML.this.out, c);
            }
            super.visit(l);
        }

        public void visit(SpotLight l) {
            if (WriterVRML.this.moveLightsToSceneRoot) {
                FactoredMatrix fm = new FactoredMatrix(this.p.getMatrix(null));
                fm.update();
                double[] c = fm.getTranslation();
                double[] dir = fm.getRotation().multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
                WriterVRML.this.writeSpotLight(l, hist, WriterVRML.this.out, c, dir);
            }
            super.visit(l);
        }
    }

    private class MyVisitor
    extends SceneGraphVisitor {
        private EffectiveAppearance effApp = EffectiveAppearance.create();
        private boolean firstTime = true;

        public MyVisitor() {
        }

        public MyVisitor(MyVisitor mv) {
            this.effApp = mv.effApp;
        }

        public void visit(SceneGraphComponent c) {
            if (!c.isVisible()) {
                return;
            }
            WriterVRML.this.out.println("" + hist + "Separator { # " + c.getName());
            String oldhist = hist;
            hist = hist + WriterVRML.spacing;
            if (this.firstTime) {
                Object obj;
                if (c.getAppearance() != null && (obj = c.getAppearance().getAttribute("infoString", String.class)) instanceof String && obj != null) {
                    String info = (String)obj;
                    WriterVRML.this.writeInfoString(info, hist + WriterVRML.spacing);
                }
                WriterVRML.this.out.println("" + hist + "ShapeHints { # some default Parameters ");
                WriterVRML.this.out.println("" + hist + WriterVRML.spacing + "vertexOrdering  UNKNOWN_ORDERING");
                WriterVRML.this.out.println("" + hist + WriterVRML.spacing + "shapeType       UNKNOWN_SHAPE_TYPE");
                WriterVRML.this.out.println("" + hist + WriterVRML.spacing + "faceType        CONVEX");
                WriterVRML.this.out.println("" + hist + "}");
                this.firstTime = false;
            }
            c.childrenAccept(new MyVisitor(this));
            super.visit(c);
            hist = oldhist;
            WriterVRML.this.out.println("" + hist + "}");
        }

        public void visit(Appearance a) {
            this.effApp = this.effApp.create(a);
            super.visit(a);
        }

        public void visit(Sphere s) {
            super.visit(s);
            if (!WriterVRML.this.dgs.getShowFaces().booleanValue()) {
                return;
            }
            WriterVRML.this.writeMaterialBinding(3, hist);
            Color amb = WriterVRML.this.dps.getAmbientColor();
            Color spec = WriterVRML.this.dps.getSpecularColor();
            Color diff = WriterVRML.this.dps.getDiffuseColor();
            double tra = WriterVRML.this.dps.getTransparency();
            if (tra != 0.0 | diff != null | spec != null | amb != null) {
                WriterVRML.this.writeMaterial(amb, diff, spec, tra, hist);
            }
            WriterVRML.this.out.println(hist + "Sphere { radius  1}");
        }

        public void visit(Cylinder c) {
            super.visit(c);
            if (!WriterVRML.this.dgs.getShowFaces().booleanValue()) {
                return;
            }
            WriterVRML.this.writeMaterialBinding(3, hist);
            Color amb = WriterVRML.this.dps.getAmbientColor();
            Color spec = WriterVRML.this.dps.getSpecularColor();
            Color diff = WriterVRML.this.dps.getDiffuseColor();
            double tra = WriterVRML.this.dps.getTransparency();
            if (tra != 0.0 | diff != null | spec != null | amb != null) {
                WriterVRML.this.writeMaterial(amb, diff, spec, tra, hist);
            }
            double[] r = MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 0.0, 0.0}).getArray();
            WriterVRML.this.out.println(hist + " Separator { # Cylinder");
            String oldHist = hist;
            hist = hist + WriterVRML.spacing;
            WriterVRML.this.out.println(hist + "MatrixTransform { matrix");
            WriterVRML.this.writeDoubleMatrix(r, 4, 4, hist + WriterVRML.spacing);
            WriterVRML.this.out.println(hist + "}");
            WriterVRML.this.out.print(hist + "Cylinder { ");
            WriterVRML.this.out.print("parts SIDES ");
            WriterVRML.this.out.print("radius  1 ");
            WriterVRML.this.out.print("height  1 ");
            WriterVRML.this.out.println("}");
            hist = oldHist;
            WriterVRML.this.out.println("" + hist + "} ");
        }

        public void visit(Geometry g) {
            WriterVRML.this.updateShaders(this.effApp);
            super.visit(g);
        }

        public void visit(PointSet p) {
            super.visit(p);
            if (!WriterVRML.this.dvs.getSpheresDraw().booleanValue() || !WriterVRML.this.dgs.getShowPoints().booleanValue() || p.getNumPoints() == 0) {
                return;
            }
            WriterVRML.this.writeMaterialBinding(3, hist);
            Color diff = WriterVRML.this.dvs.getDiffuseColor();
            if (diff != null) {
                WriterVRML.this.writeMaterial(null, diff, null, 0.0, hist);
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isDefinedPointSet(p)) {
                WriterVRML.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(p.hashCode() + "POINT") + " ");
                return;
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isMultipleUsedPointSet(p)) {
                WriterVRML.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(p.hashCode() + "POINT") + " ");
                WriterVRML.this.wHelp.setDefinedPointSet(p);
            } else {
                WriterVRML.this.out.print("" + hist);
            }
            WriterVRML.this.out.println(" Separator { ");
            WriterVRML.this.writeGeoPoints(p, hist + WriterVRML.spacing);
            WriterVRML.this.out.println("" + hist + "} ");
        }

        public void visit(IndexedLineSet g) {
            super.visit(g);
            if (!WriterVRML.this.dls.getTubeDraw().booleanValue() || !WriterVRML.this.dgs.getShowLines().booleanValue() || g.getNumEdges() == 0) {
                return;
            }
            WriterVRML.this.writeMaterialBinding(3, hist);
            Color diff = WriterVRML.this.dls.getDiffuseColor();
            if (diff != null) {
                WriterVRML.this.writeMaterial(null, diff, null, 0.0, hist);
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isDefinedLineSet(g)) {
                WriterVRML.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(g.hashCode() + "LINE") + " ");
                return;
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isMultipleUsedLineSet(g)) {
                WriterVRML.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(g.hashCode() + "LINE") + " ");
                WriterVRML.this.wHelp.setDefinedLineSet(g);
            } else {
                WriterVRML.this.out.print("" + hist);
            }
            WriterVRML.this.out.println(" Separator { ");
            WriterVRML.this.writeGeoLines(g, hist + WriterVRML.spacing);
            WriterVRML.this.out.println("" + hist + "} ");
        }

        public void visit(IndexedFaceSet g) {
            super.visit(g);
            if (!WriterVRML.this.dgs.getShowFaces().booleanValue() || g.getNumFaces() == 0) {
                return;
            }
            WriterVRML.this.writeMaterialBinding(3, hist);
            Color amb = WriterVRML.this.dps.getAmbientColor();
            Color spec = WriterVRML.this.dps.getSpecularColor();
            Color diff = WriterVRML.this.dps.getDiffuseColor();
            double tra = WriterVRML.this.dps.getTransparency();
            if (tra != 0.0 | diff != null | spec != null | amb != null) {
                WriterVRML.this.writeMaterial(amb, diff, spec, tra, hist);
            }
            try {
                double[][] texCoords = VRMLWriterHelper.getDoubleDoubleVertexAttr(g, Attribute.TEXTURE_COORDINATES);
                if (texCoords == null) {
                    throw new IOException("missing texture component");
                }
                Texture2D tex = WriterVRML.this.dps.getTexture2d();
                if (tex == null) {
                    throw new IOException("missing texture component");
                }
                Matrix mat = tex.getTextureMatrix();
                if (mat == null) {
                    throw new IOException("missing texture component");
                }
                ImageData id = tex.getImage();
                if (id == null) {
                    throw new IOException("missing texture component");
                }
                WriterVRML.this.writeTexCoords(texCoords, hist);
                WriterVRML.this.writeTexture(tex, hist);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isDefinedFaceSet(g)) {
                WriterVRML.this.out.println("" + hist + "USE " + VRMLWriterHelper.str(g.hashCode() + "POLYGON") + " ");
                return;
            }
            if (WriterVRML.this.useDefs && WriterVRML.this.wHelp.isMultipleUsedFaceSet(g)) {
                WriterVRML.this.out.print("" + hist + "DEF " + VRMLWriterHelper.str(g.hashCode() + "POLYGON") + " ");
                WriterVRML.this.wHelp.setDefinedFaceSet(g);
            } else {
                WriterVRML.this.out.print("" + hist);
            }
            WriterVRML.this.out.println(" Separator { ");
            WriterVRML.this.writeGeoFaces(g, hist + WriterVRML.spacing);
            WriterVRML.this.out.println("" + hist + "} ");
        }

        public void visit(Light l) {
            super.visit(l);
        }

        public void visit(DirectionalLight l) {
            if (WriterVRML.this.moveLightsToSceneRoot) {
                return;
            }
            WriterVRML.this.writeDirLight(l, hist, WriterVRML.this.out, null);
            super.visit(l);
        }

        public void visit(PointLight l) {
            if (WriterVRML.this.moveLightsToSceneRoot) {
                return;
            }
            if (!(l instanceof SpotLight)) {
                WriterVRML.this.writePointLight(l, hist, WriterVRML.this.out, null);
            }
            super.visit(l);
        }

        public void visit(SpotLight l) {
            if (WriterVRML.this.moveLightsToSceneRoot) {
                return;
            }
            WriterVRML.this.writeSpotLight(l, hist, WriterVRML.this.out, null, null);
            super.visit(l);
        }

        public void visit(Camera c) {
            if (c.isPerspective()) {
                WriterVRML.this.out.println(hist + "PerspectiveCamera { ");
                String oldHist = hist;
                hist = hist + WriterVRML.spacing;
                WriterVRML.this.out.println(hist + "focalDistance " + c.getFocalLength());
                double hAngle = c.getFieldOfView() * Math.PI / 180.0;
                WriterVRML.this.out.println(hist + "heightAngle " + hAngle);
                hist = oldHist;
                WriterVRML.this.out.println(hist + "}");
            } else {
                System.out.println("WriterVRML.writeCam(not completely implemented)");
            }
            super.visit(c);
        }

        public void visit(Transformation t) {
            WriterVRML.this.out.println(hist + "MatrixTransform { matrix");
            WriterVRML.this.writeDoubleMatrix(t.getMatrix(), 4, 4, hist + WriterVRML.spacing);
            WriterVRML.this.out.println(hist + "}");
            super.visit(t);
        }
    }
}

