/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import java.awt.Color;

public class ColorGradient {
    Color[] color;
    double time = 0.0;

    public ColorGradient(Color ... key) {
        int k;
        Color[][] range = new Color[key.length - 1][];
        int totalNumberOfColors = 1;
        for (k = 0; k < range.length; ++k) {
            int redAt0 = key[k].getRed();
            int greenAt0 = key[k].getGreen();
            int blueAt0 = key[k].getBlue();
            int redAt1 = key[k + 1].getRed();
            int greenAt1 = key[k + 1].getGreen();
            int blueAt1 = key[k + 1].getBlue();
            int distRed = Math.abs(redAt0 - redAt1);
            int distGreen = Math.abs(greenAt0 - greenAt1);
            int distBlue = Math.abs(blueAt0 - blueAt1);
            int maxDist = Math.max(distRed, Math.max(distGreen, distBlue));
            totalNumberOfColors += maxDist;
            float denom = maxDist;
            range[k] = new Color[maxDist + 1];
            range[k][0] = key[k];
            range[k][maxDist] = key[k + 1];
            for (int i = 1; i < maxDist; ++i) {
                float t = (float)i / denom;
                range[k][i] = new Color(((1.0f - t) * (float)redAt0 + t * (float)redAt1) / 255.0f, ((1.0f - t) * (float)greenAt0 + t * (float)greenAt1) / 255.0f, ((1.0f - t) * (float)blueAt0 + t * (float)blueAt1) / 255.0f);
            }
        }
        this.color = new Color[totalNumberOfColors];
        int o = 0;
        for (k = 0; k < range.length; ++k) {
            System.arraycopy(range[k], 0, this.color, o, range[k].length - 1);
            o += range[k].length - 1;
        }
        this.color[totalNumberOfColors - 1] = key[key.length - 1];
    }

    public ColorGradient() {
        this(Color.blue, Color.cyan, Color.green, Color.yellow, Color.red);
    }

    public static ColorGradient getFullPeriodicColorGradient() {
        return new ColorGradient(Color.blue, Color.cyan, Color.green, Color.yellow, Color.red, Color.magenta, Color.blue);
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double aDouble) {
        this.time = aDouble;
    }

    public Color getColorValue() {
        return this.getColor(this.time);
    }

    public Color getColor(double t) {
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        return this.color[(int)((double)(this.color.length - 1) * t + 0.5)];
    }

    public Color[] getColor() {
        return this.color;
    }
}

