/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.util.GuiUtility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ToggleShowCursor
extends AbstractJrAction {
    private Viewer viewer;

    public ToggleShowCursor(String name, Viewer viewer) {
        super(name);
        this.viewer = viewer;
        this.setShortDescription("Toggle show cursor in viewing component");
        this.setAcceleratorKey(KeyStroke.getKeyStroke(120, 1));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.viewer.hasViewingComponent() && this.viewer.getViewingComponent() instanceof Component) {
            boolean hide;
            Component viewingCmp = (Component)this.viewer.getViewingComponent();
            boolean bl = hide = viewingCmp.getCursor().getType() == 0;
            if (hide) {
                GuiUtility.hideCursor(viewingCmp);
            } else {
                GuiUtility.showCursor(viewingCmp);
            }
        }
    }
}

