/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CubeMap;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class RotateSkyboxSides
extends AbstractJrAction {
    private SceneGraphComponent sceneRoot;

    public RotateSkyboxSides(String name, SceneGraphComponent sceneRoot, Component frame) {
        super(name, frame);
        this.sceneRoot = sceneRoot;
        this.setShortDescription("Rotate skybox sides to match its top and bottom");
    }

    public void actionPerformed(ActionEvent e) {
        Appearance app = this.sceneRoot.getAppearance();
        if (app == null) {
            System.err.println("No skybox loaded.");
            return;
        }
        CubeMap cm = (CubeMap)AttributeEntityUtility.getAttributeEntity(CubeMap.class, "skyBox", app, true);
        if (cm.getFront() == null) {
            System.err.println("No skybox loaded.");
            return;
        }
        ImageData[] imgs = TextureUtility.getCubeMapImages(cm);
        int[] order = new int[]{5, 4, 2, 3, 0, 1};
        ImageData[] newImgs = new ImageData[6];
        for (int i = 0; i < newImgs.length; ++i) {
            newImgs[i] = imgs[order[i]];
        }
        TextureUtility.createSkyBox(app, newImgs);
    }
}

