/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.io.JrScene;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.writer.WriterJRS;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SaveScene
extends AbstractJrAction {
    private Viewer viewer;

    public SaveScene(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Save scene as a file");
        this.setShortCut(83, 0, true);
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, "jrs", "jReality scene files");
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            WriterJRS writer = new WriterJRS();
            JrScene s = new JrScene(this.viewer.getSceneRoot());
            s.addPath("cameraPath", this.viewer.getCameraPath());
            ToolSystem ts = ToolSystem.toolSystemForViewer(this.viewer);
            s.addPath("avatarPath", ts.getAvatarPath());
            s.addPath("emptyPickPath", ts.getEmptyPickPath());
            writer.writeScene(s, fos);
            fos.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parentComp, "Save failed: " + ioe.getMessage());
        }
    }
}

