/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.scene.Viewer;
import de.jreality.softviewer.SVGRenderer;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class ExportSVG
extends AbstractJrAction {
    private Viewer viewer;

    public ExportSVG(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export SVG file");
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, "svg", "SVG files");
        if (file == null) {
            return;
        }
        Dimension d = this.viewer.getViewingComponentSize();
        try {
            SVGRenderer rv = new SVGRenderer(new PrintWriter(file), d.width, d.height);
            rv.setCameraPath(this.viewer.getCameraPath());
            rv.setSceneRoot(this.viewer.getSceneRoot());
            rv.setAuxiliaryRoot(this.viewer.getAuxiliaryRoot());
            rv.render();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }
}

