/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class ToggleAppearance
extends AbstractSelectionListenerAction {
    private String attribute;
    private boolean defaultValue;

    public ToggleAppearance(String name, String attribute, SelectionManager sm) {
        super(name, sm);
        this.attribute = attribute;
        if (attribute.equals("showPoints")) {
            this.defaultValue = true;
            this.setShortDescription("Toggle vertex drawing of responsible appearance");
            this.setShortCut(86, 0, true);
        } else if (attribute.equals("showLines")) {
            this.defaultValue = true;
            this.setShortDescription("Toggle edge drawing of responsible appearance");
            this.setShortCut(69, 0, true);
        } else if (attribute.equals("showFaces")) {
            this.defaultValue = true;
            this.setShortDescription("Toggle face drawing of responsible appearance");
            this.setShortCut(70, 0, true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object value = null;
        SceneGraphComponent cmp = null;
        Appearance app = null;
        Iterator it = this.getSelection().reverseIterator();
        while (it.hasNext()) {
            try {
                cmp = (SceneGraphComponent)it.next();
            }
            catch (ClassCastException cce) {
                continue;
            }
            Appearance a = cmp.getAppearance();
            if (a != null) {
                value = a.getAttribute(this.attribute);
                if (app == null) {
                    app = a;
                }
            }
            if (!(value instanceof Boolean)) continue;
        }
        if (app == null) {
            return;
        }
        if (!(value instanceof Boolean)) {
            value = this.defaultValue;
        }
        app.setAttribute(this.attribute, !((Boolean)value).booleanValue());
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected() || e.appearanceSelected();
    }
}

