/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.writer.SceneWriter;
import de.jreality.writer.WriterJRS;
import de.jreality.writer.u3d.WriterU3D;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SaveSelected
extends AbstractSelectionListenerAction {
    FileFilter ff = new FileFilter("Supported file formats", "jrs", "u3d");

    public SaveSelected(String name, SelectionManager sm, Component parentComp) {
        super(name, sm, parentComp);
        this.setShortDescription("Save selected SceneGraphComponent as a file");
        this.setShortCut(83, 1, true);
    }

    public void actionPerformed(ActionEvent e) {
        File file = FileLoaderDialog.selectTargetFile(this.parentComp, false, this.ff);
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            String lc = file.getName().toLowerCase();
            SceneWriter writer = lc.endsWith(".jrs") ? new WriterJRS() : new WriterU3D();
            writer.write(this.getSelection().getLastComponent(), fos);
            fos.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parentComp, "Save failed: " + ioe.getMessage(), "IO Error", 0);
        }
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected();
    }
}

