/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.Appearance;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CubeMap;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class RotateReflectionMapSides
extends AbstractSelectionListenerAction {
    public RotateReflectionMapSides(String name, SelectionManager sm, Component frame) {
        super(name, sm, frame);
        this.setShortDescription("Rotate reflection map sides to match its top and bottom");
    }

    public void actionPerformed(ActionEvent e) {
        Appearance app = null;
        app = this.getSelection().isComponent() ? this.getSelection().getLastComponent().getAppearance() : (Appearance)this.getSelection().getLastNode();
        if (app == null) {
            System.err.println("No reflection map loaded.");
            return;
        }
        CubeMap cm = (CubeMap)AttributeEntityUtility.getAttributeEntity(CubeMap.class, "polygonShader.reflectionMap", app, true);
        if (cm.getFront() == null) {
            System.err.println("No reflection map loaded.");
            return;
        }
        ImageData[] imgs = TextureUtility.getCubeMapImages(cm);
        int[] order = new int[]{5, 4, 2, 3, 0, 1};
        ImageData[] newImgs = new ImageData[6];
        for (int i = 0; i < newImgs.length; ++i) {
            newImgs[i] = imgs[order[i]];
        }
        TextureUtility.createReflectionMap(app, "polygonShader", newImgs);
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected() || e.appearanceSelected();
    }
}

