/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.Appearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.util.Input;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;

public class LoadReflectionMap
extends AbstractSelectionListenerAction {
    public LoadReflectionMap(String name, SelectionManager sm, Component frame) {
        super(name, sm, frame);
        this.setShortDescription("Load reflection map");
    }

    public void actionPerformed(ActionEvent e) {
        ImageData[] imgs;
        File file = FileLoaderDialog.loadFile(this.parentComp, false, new FileFilter("ZIP archives", "zip"));
        if (file == null) {
            return;
        }
        try {
            imgs = TextureUtility.createCubeMapData(Input.getInput(file));
        }
        catch (Exception ex) {
            System.err.println("Couldn't create cube map data from zip-file");
            ex.printStackTrace();
            return;
        }
        Appearance app = null;
        if (this.getSelection().isComponent()) {
            app = this.getSelection().asComponent().getAppearance();
            if (app == null) {
                app = new Appearance();
                this.getSelection().asComponent().setAppearance(app);
            }
        } else {
            app = (Appearance)this.getSelection().asNode();
        }
        TextureUtility.createReflectionMap(app, "polygonShader", imgs);
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected() || e.appearanceSelected();
    }
}

