/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.edit;

import de.jreality.scene.tool.Tool;
import de.jreality.tools.AirplaneTool;
import de.jreality.tools.ClickWheelCameraZoomTool;
import de.jreality.tools.DampedDraggingTool;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.EncompassTool;
import de.jreality.tools.FlyToPickTool;
import de.jreality.tools.FlyTool;
import de.jreality.tools.HeadTransformationTool;
import de.jreality.tools.LookAtTool;
import de.jreality.tools.PickShowTool;
import de.jreality.tools.PointerDisplayTool;
import de.jreality.tools.RotateTool;
import de.jreality.tools.ScaleTool;
import de.jreality.tools.ShipNavigationTool;
import de.jreality.tools.ShipRotateTool;
import de.jreality.tools.ShipScaleTool;
import de.jreality.tools.ShowPropertiesTool;
import de.jreality.tools.TranslateTool;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class AddTool
extends AbstractSelectionListenerAction {
    private boolean initialized = false;
    private JList toolList = null;
    private JOptionPane pane = null;
    private JDialog dialog = null;

    public AddTool(String name, SelectionManager sm, Component frame) {
        super(name, sm, frame);
        this.setShortDescription("Add Tools");
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.initialized) {
            this.initializeToolList();
        }
        this.dialog.setLocationRelativeTo(this.parentComp);
        this.dialog.setVisible(true);
        if (this.pane.getValue() instanceof Integer && (Integer)this.pane.getValue() == 0) {
            Object[] selectedTools = this.toolList.getSelectedValues();
            for (int i = 0; i < selectedTools.length; ++i) {
                try {
                    Tool t = (Tool)Class.forName((String)selectedTools[i]).newInstance();
                    this.getSelection().getLastComponent().addTool(t);
                    continue;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        this.toolList.clearSelection();
    }

    public boolean isEnabled(SelectionEvent e) {
        return e.componentSelected();
    }

    private void initializeToolList() {
        LinkedList<String> tools = new LinkedList<String>();
        tools.add(AirplaneTool.class.getName());
        tools.add(ClickWheelCameraZoomTool.class.getName());
        tools.add(DampedDraggingTool.class.getName());
        tools.add(DraggingTool.class.getName());
        tools.add(EncompassTool.class.getName());
        tools.add(FlyTool.class.getName());
        tools.add(FlyToPickTool.class.getName());
        tools.add(HeadTransformationTool.class.getName());
        tools.add(LookAtTool.class.getName());
        tools.add(PickShowTool.class.getName());
        tools.add(PointerDisplayTool.class.getName());
        tools.add(RotateTool.class.getName());
        tools.add(ScaleTool.class.getName());
        tools.add(ShipNavigationTool.class.getName());
        tools.add(ShipRotateTool.class.getName());
        tools.add(ShipScaleTool.class.getName());
        tools.add(ShowPropertiesTool.class.getName());
        tools.add(TranslateTool.class.getName());
        try {
            tools.add(Class.forName("de.jreality.tools.PortalHeadMoveTool").getName());
        }
        catch (ClassNotFoundException exc) {
            // empty catch block
        }
        Object[] obj = tools.toArray();
        Arrays.sort(obj);
        this.toolList = new JList<Object>(obj);
        this.toolList.setSelectionMode(2);
        this.pane = new JOptionPane(new JScrollPane(this.toolList), -1, 2);
        this.dialog = this.pane.createDialog(this.parentComp, "Add Tools");
        this.toolList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    AddTool.this.dialog.setVisible(false);
                    AddTool.this.pane.setValue(0);
                }
            }
        });
        this.initialized = true;
    }
}

