/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.camera;

import de.jreality.scene.Camera;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.actions.camera.AbstractCameraAction;
import de.jreality.util.CameraUtility;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ShiftEyeSeparation
extends AbstractCameraAction {
    public ShiftEyeSeparation(String name, Viewer v, boolean decrease) {
        super(name, v);
        this.setStep(0.1);
        if (decrease) {
            this.setStep(-this.getStep());
            this.setShortDescription("Decrease the eye separation of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(116, 1));
        } else {
            this.setShortDescription("Increase the eye separation of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(117, 1));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Camera camera = CameraUtility.getCamera(this.viewer);
        camera.setEyeSeparation(camera.getEyeSeparation() + this.getStep());
        this.viewer.render();
    }
}

