/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.jogl.ViewerSwt;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.ui.viewerapp.SelectionManagerImpl;
import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ViewerAppSwt
extends AbstractViewerApp {
    private Composite comp;

    public ViewerAppSwt(SceneGraphNode node, Composite parent) {
        this(node, null, null, null, null, parent);
    }

    public ViewerAppSwt(SceneGraphNode contentNode, SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar, Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new FillLayout());
        this.init(contentNode, root, cameraPath, emptyPick, avatar);
    }

    public synchronized void dispose() {
        if (this.autoRender) {
            this.renderTrigger.removeSceneGraphComponent(this.sceneRoot);
            this.renderTrigger.removeViewer(this.viewerSwitch);
        }
        if (this.toolSystem != null) {
            this.toolSystem.dispose();
        }
        this.viewerSwitch.dispose();
        SelectionManagerImpl.disposeForViewer(this.viewerSwitch);
        this.comp.dispose();
        if (this.viewers != null && this.viewers.length > 0) {
            for (Viewer v : this.viewers) {
                if (v == null) continue;
                v.setSceneRoot(null);
                v.setCameraPath(null);
                v.setAuxiliaryRoot(null);
            }
            this.viewers = null;
        }
    }

    public ViewerAppMenu getMenu() {
        return null;
    }

    public void showExternalNavigator(boolean show) {
    }

    public void showExternalBeanShell(boolean show) {
    }

    public void setupNavigator() {
    }

    public void setupBeanShell() {
    }

    protected ToolSystem createToolSystem() throws IOException {
        String config = Secure.getProperty("de.jreality.scene.tool.Config", "defaultSwt");
        boolean remotePortal = config.equals("portal-remote");
        if (this.viewers == null) {
            if (remotePortal) {
                System.err.println("Upps I should be here");
            } else {
                LinkedList<ViewerSwt> viewerList = new LinkedList<ViewerSwt>();
                try {
                    ViewerSwt viewerSwt = new ViewerSwt(null, null, this.comp);
                    viewerList.add(viewerSwt);
                }
                catch (Exception e) {
                    System.err.println("Exception in creating Viewer");
                    e.printStackTrace();
                    LoggingSystem.getLogger(this).info("could not create ViewerSwt instance");
                }
                catch (NoClassDefFoundError ndfe) {
                }
                catch (UnsatisfiedLinkError le) {
                    // empty catch block
                }
                this.viewers = viewerList.toArray(new Viewer[viewerList.size()]);
            }
        }
        if (this.viewerSwitch == null) {
            this.viewerSwitch = new ViewerSwitch(this.viewers);
        }
        LoggingSystem.getLogger(this).fine("current viewer of viewer switch is " + this.viewerSwitch.getCurrentViewer());
        ToolSystemConfiguration cfg = this.loadToolSystemConfiguration(config);
        if (!remotePortal && this.toolSystem == null) {
            this.toolSystem = new ToolSystem(this.viewerSwitch.getCurrentViewer(), cfg, this.synchRender ? this.renderTrigger : null);
        }
        this.viewerSwitch.setToolSystem(this.toolSystem);
        return this.toolSystem;
    }

    public void update() {
    }

    public void display() {
    }

    public Composite getComposite() {
        return this.comp;
    }
}

