/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.ui.treeview.JTreeRenderer;
import de.jreality.ui.treeview.SceneTreeModel;
import de.jreality.ui.viewerapp.Selection;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.SelectionManagerImpl;
import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jtem.beans.BooleanEditor;
import de.jtem.beans.EditorSpawner;
import de.jtem.beans.InspectorPanel;
import de.jtem.beans.NumberSpinnerEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class Navigator
implements de.jreality.ui.viewerapp.SelectionListener {
    private InspectorPanel inspector;
    private JTree sceneTree;
    private SceneTreeModel treeModel;
    private TreeSelectionModel tsm;
    private SelectionManager selectionManager;
    private SelectionManager externalSelectionManager;
    private Viewer viewer;
    private Container navigator;
    private Component parentComp;
    private Component toolBar;
    private JCheckBox receiveCheckBox;
    private JCheckBox propagateCheckBox;

    public Navigator(Viewer viewer) {
        this(viewer, null);
    }

    public Navigator(Viewer viewer, Component parentComp) {
        this.externalSelectionManager = SelectionManagerImpl.selectionManagerForViewer(viewer);
        this.selectionManager = new SelectionManagerImpl(this.externalSelectionManager.getDefaultSelection());
        this.toolBar = this.createToolBar();
        this.setReceiveSelections(true);
        this.parentComp = parentComp;
        this.inspector = new InspectorPanel(false);
        BooleanEditor.setNameOfNull((String)"inherit");
        EditorSpawner.setNameOfNull((String)"inherit");
        EditorSpawner.setNameOfCreation((String)"inherited");
        NumberSpinnerEditor.setNameOfNull((String)"inherit");
        NumberSpinnerEditor.setNameOfCreation((String)"inherited");
        this.sceneTree = new JTree();
        this.treeModel = new SceneTreeModel(viewer.getSceneRoot());
        this.sceneTree.setModel(this.treeModel);
        this.sceneTree.setAnchorSelectionPath(new TreePath(this.treeModel.convertSelection(this.selectionManager.getDefaultSelection())));
        this.sceneTree.setCellRenderer(new JTreeRenderer());
        this.sceneTree.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "toggle");
        this.tsm = this.sceneTree.getSelectionModel();
        this.tsm.setSelectionMode(1);
        this.tsm.addTreeSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Selection currentSelection = e.getSelection();
                Navigator.this.inspector.setObject(currentSelection.getLastElement());
                Navigator.this.inspector.refresh();
                Navigator.this.selectionManager.setSelection(currentSelection);
                if (Navigator.this.isPropagateSelections()) {
                    Navigator.this.externalSelectionManager.setSelection(currentSelection);
                }
            }
        });
        try {
            this.tsm.setSelectionPath(new TreePath(this.treeModel.convertSelection(this.selectionManager.getDefaultSelection())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setupContextMenu();
    }

    public void selectionChanged(de.jreality.ui.viewerapp.SelectionEvent e) {
        Object[] selection = null;
        try {
            selection = this.treeModel.convertSelection(e.getSelection());
            TreePath path = new TreePath(selection);
            if (e.nodeSelected() && !path.equals(this.tsm.getSelectionPath())) {
                this.tsm.setSelectionPath(path);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public InspectorPanel getInspector() {
        return this.inspector;
    }

    public JTree getSceneTree() {
        return this.sceneTree;
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.tsm;
    }

    public SceneGraphComponent getSceneRoot() {
        return this.viewer.getSceneRoot();
    }

    public Selection getSelection() {
        return this.selectionManager.getSelection();
    }

    private void setupContextMenu() {
        final JPopupMenu cm = new JPopupMenu();
        cm.setLightWeightPopupEnabled(false);
        JMenu editMenu = null;
        ActionMap editActions = null;
        try {
            editMenu = ViewerAppMenu.createEditMenu(this.parentComp, this.selectionManager);
            editActions = ViewerAppMenu.updateActionMap(editMenu.getActionMap(), editMenu);
        }
        catch (Exception e) {
            return;
        }
        for (Component c : editMenu.getMenuComponents()) {
            cm.add(c);
        }
        this.sceneTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            private void handlePopup(MouseEvent e) {
                TreePath path;
                if (e.isPopupTrigger() && (path = Navigator.this.sceneTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    Navigator.this.tsm.clearSelection();
                    Navigator.this.tsm.setSelectionPath(path);
                    cm.show(e.getComponent(), e.getX(), e.getY() + 10);
                }
            }
        });
        try {
            Object[] keys = editActions.keys();
            for (int i = 0; i < keys.length; ++i) {
                KeyStroke key = (KeyStroke)keys[i];
                this.sceneTree.getInputMap().put(key, key);
                this.sceneTree.getActionMap().put(key, editActions.get(key));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Component getComponent() {
        if (this.navigator == null) {
            this.sceneTree.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JScrollPane top = new JScrollPane(this.sceneTree);
            top.setPreferredSize(new Dimension(1, 1));
            top.setBorder(BorderFactory.createEmptyBorder());
            this.inspector.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JScrollPane bottom = new JScrollPane((Component)this.inspector);
            bottom.setPreferredSize(new Dimension(1, 1));
            bottom.setBorder(BorderFactory.createEmptyBorder());
            JSplitPane navigator = new JSplitPane(0, top, bottom);
            navigator.setResizeWeight(0.6);
            navigator.setContinuousLayout(true);
            navigator.setOneTouchExpandable(true);
            this.navigator = new JPanel();
            this.navigator.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.navigator.add(this.toolBar, c);
            this.navigator.add((Component)new JSeparator(), c);
            c.weighty = 1.0;
            this.navigator.add((Component)navigator, c);
        }
        return this.navigator;
    }

    private Component createToolBar() {
        JPanel checkerPanel = new JPanel();
        checkerPanel.setLayout(new GridLayout(1, 2));
        this.propagateCheckBox = new JCheckBox();
        AbstractAction a = new AbstractAction("Propagate"){
            private static final long serialVersionUID = 1L;
            {
                this.putValue("ShortDescription", "Propagate selections to the SelectionManager");
            }

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.propagateCheckBox.setAction(a);
        checkerPanel.add(this.propagateCheckBox);
        this.receiveCheckBox = new JCheckBox();
        a = new AbstractAction("Receive"){
            private static final long serialVersionUID = 1L;
            {
                this.putValue("ShortDescription", "Receive selections from the SelectionManager");
            }

            public void actionPerformed(ActionEvent e) {
                Navigator.this.updateReceiveSelections();
            }
        };
        this.receiveCheckBox.setAction(a);
        checkerPanel.add(this.receiveCheckBox);
        return checkerPanel;
    }

    public void setReceiveSelections(boolean receive) {
        this.receiveCheckBox.setSelected(receive);
    }

    public boolean isReceiveSelections() {
        return this.receiveCheckBox.isSelected();
    }

    private void updateReceiveSelections() {
        if (this.receiveCheckBox.isSelected()) {
            this.externalSelectionManager.addSelectionListener(this);
        } else {
            this.externalSelectionManager.removeSelectionListener(this);
        }
    }

    public boolean isPropagateSelections() {
        return this.propagateCheckBox.isSelected();
    }

    public void setPropagateSelections(boolean propagate) {
        this.propagateCheckBox.setSelected(propagate);
    }

    public static class SelectionEvent
    extends TreeSelectionEvent {
        private static final long serialVersionUID = 1L;

        public SelectionEvent(Object source, TreePath[] paths, boolean[] areNew, TreePath oldLeadSelectionPath, TreePath newLeadSelectionPath) {
            super(source, paths, areNew, oldLeadSelectionPath, newLeadSelectionPath);
        }

        private Object convert(Object o) {
            if (o instanceof SceneTreeNode) {
                return ((SceneTreeNode)o).getNode();
            }
            if (o instanceof SceneTreeModel.TreeTool) {
                return ((SceneTreeModel.TreeTool)o).getTool();
            }
            return o;
        }

        public Selection getSelection() {
            Selection selection = new Selection();
            Object[] treePath = this.getPath().getPath();
            for (int i = 0; i < treePath.length; ++i) {
                selection.push(this.convert(treePath[i]));
            }
            return selection;
        }
    }

    public static abstract class SelectionListener
    implements TreeSelectionListener {
        public abstract void selectionChanged(SelectionEvent var1);

        public void valueChanged(TreeSelectionEvent e) {
            boolean[] areNew = new boolean[e.getPaths().length];
            for (int i = 0; i < areNew.length; ++i) {
                areNew[i] = e.isAddedPath(i);
            }
            SelectionEvent se = new SelectionEvent(e.getSource(), e.getPaths(), areNew, e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
            this.selectionChanged(se);
        }
    }
}

