/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualRotationFromRxRyRz
implements VirtualDevice {
    InputSlot rxSlot;
    InputSlot rySlot;
    InputSlot rzSlot;
    InputSlot outSlot;
    double rx;
    double ry;
    double rz;
    double gain = 1.0;
    MatrixBuilder mb = MatrixBuilder.euclidean();
    DoubleArray outArray = new DoubleArray(this.mb.getArray());

    public ToolEvent process(VirtualDeviceContext context) {
        try {
            this.rx = context.getAxisState(this.rxSlot).doubleValue();
            this.ry = context.getAxisState(this.rySlot).doubleValue();
            this.rz = context.getAxisState(this.rzSlot).doubleValue();
        }
        catch (MissingSlotException mse) {
            System.out.println("VirtualRotationFromRxRyRz.process(): missing slot");
        }
        this.mb.reset();
        this.mb.rotateX(this.rx * this.gain);
        this.mb.rotateZ(this.ry * this.gain);
        this.mb.rotateY(-this.rz * this.gain);
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, this.outArray);
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.outSlot = result;
        this.rxSlot = (InputSlot)inputSlots.get(0);
        this.rySlot = (InputSlot)inputSlots.get(1);
        this.rzSlot = (InputSlot)inputSlots.get(2);
        if (configuration != null) {
            try {
                this.gain = (Double)configuration.get("gain");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "RotationFromRxRyRz";
    }

    public String toString() {
        return "VirtualDevice: " + this.getName();
    }
}

