/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import de.jreality.util.LoggingSystem;
import java.util.List;
import java.util.Map;

public class VirtualRotationAboutAxis
implements VirtualDevice {
    InputSlot angle;
    InputSlot out;
    MatrixBuilder mb = MatrixBuilder.euclidean();
    DoubleArray da = new DoubleArray(this.mb.getMatrix().getArray());
    double[] axis;
    double gain = 1.0;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        this.mb.reset().rotate(this.gain * context.getAxisState(this.angle).doubleValue(), this.axis);
        return new ToolEvent((Object)this, context.getEvent().getTimeStamp(), this.out, this.da);
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.angle = (InputSlot)inputSlots.get(0);
        this.out = result;
        if (configuration.containsKey("gain")) {
            try {
                this.gain = (Double)configuration.get("gain");
            }
            catch (NumberFormatException nfe) {
                LoggingSystem.getLogger(this).warning("unsupported config string");
            }
        }
        if (configuration.get("axis").equals("X-axis")) {
            this.axis = new double[]{1.0, 0.0, 0.0};
            return;
        }
        if (configuration.get("axis").equals("Y-axis")) {
            this.axis = new double[]{0.0, 1.0, 0.0};
            return;
        }
        if (configuration.get("axis").equals("Z-axis")) {
            this.axis = new double[]{0.0, 0.0, 1.0};
            return;
        }
        try {
            this.axis = (double[])configuration.get("axis");
        }
        catch (Exception nfe) {
            throw new IllegalArgumentException("unsupported config string");
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "VirtualDevice: RotateAroundAxis";
    }
}

