/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.Matrix;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualMergedNDC
implements VirtualDevice {
    InputSlot inX;
    InputSlot inY;
    InputSlot outSlot;
    DoubleArray da;
    Matrix mat = new Matrix();
    double factorX = 1.0;
    double factorY = 1.0;

    public VirtualMergedNDC() {
        this.da = new DoubleArray(this.mat.getArray());
        this.mat.setEntry(2, 3, -1.0);
    }

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        try {
            this.mat.setEntry(0, 3, this.factorX * context.getAxisState(this.inX).doubleValue());
            this.mat.setEntry(1, 3, this.factorY * context.getAxisState(this.inY).doubleValue());
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, this.da);
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inX = (InputSlot)inputSlots.get(0);
        this.inY = (InputSlot)inputSlots.get(1);
        this.outSlot = result;
        try {
            this.factorX = (Double)configuration.get("factorX");
            this.factorY = (Double)configuration.get("factorY");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "MergedNDC";
    }

    public String toString() {
        return "Virtual Device: " + this.getName();
    }
}

