/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualBumpAxis
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    AxisState state;
    double eps = 0.1;
    double lastVal = Double.NaN;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double val = context.getAxisState(this.inSlot).doubleValue();
        double ret = 0.0;
        if (Math.abs(val) > this.eps) {
            ret = Math.pow(val + this.eps, 2.0) * Math.pow(val - this.eps, 2.0) * Math.signum(val);
        }
        if (ret == this.lastVal) {
            return null;
        }
        this.lastVal = ret;
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(ret));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        Double ed = (Double)configuration.get("eps");
        if (ed != null) {
            this.eps = ed;
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "BumpAxis";
    }
}

