/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.jogl.ViewerSwt;
import de.jreality.scene.Viewer;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.LoggingSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Canvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceKeyboardSWT
implements RawDevice,
KeyListener {
    private HashMap keysToVirtual = new HashMap();
    private ToolEventQueue queue;
    private Canvas component;
    private HashMap pendingReleases = new HashMap();
    HashSet pressed = new HashSet();

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        if (!(viewer instanceof ViewerSwt)) {
            throw new RuntimeException("only for SWT viewer!");
        }
        this.setComponent((Canvas)((ViewerSwt)viewer).getGLCanvas());
    }

    public void setComponent(final Canvas component) {
        this.component = component;
        Runnable r = new Runnable(){

            public void run() {
                component.addKeyListener((KeyListener)DeviceKeyboardSWT.this);
            }
        };
        component.getDisplay().asyncExec(r);
    }

    public synchronized void keyPressed(KeyEvent e) {
        InputSlot id = (InputSlot)this.keysToVirtual.get(new Integer(e.keyCode));
        if (id != null && !this.pressed.contains(id)) {
            ToolEvent ev = new ToolEvent((Object)this, id, AxisState.PRESSED);
            this.queue.addEvent(ev);
            LoggingSystem.getLogger(this).fine(this.hashCode() + " added key pressed [" + id + "] " + e.time);
            this.pressed.add(id);
        }
    }

    public synchronized void keyReleased(KeyEvent e) {
        InputSlot id = (InputSlot)this.keysToVirtual.get(new Integer(e.keyCode));
        this.pressed.remove(id);
        this.queue.addEvent(new ToolEvent((Object)this, id, AxisState.ORIGIN));
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        this.keysToVirtual.put(new Integer(Integer.parseInt(rawDeviceName)), inputDevice);
        return new ToolEvent((Object)this, inputDevice, AxisState.ORIGIN);
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return "Keyboard";
    }

    public String toString() {
        return "RawDevice: Keyboard";
    }
}

