/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

public class ShipScaleTool
extends AbstractTool {
    InputSlot scaleSlot = InputSlot.getDevice("ScaleAxis");
    InputSlot timerSlot = InputSlot.getDevice("SystemTime");
    double factor;
    boolean isScaling;
    double gain = 1.0;
    double[] tmp = new double[16];

    public ShipScaleTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.scaleSlot);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == this.scaleSlot) {
            this.factor = tc.getAxisState(this.scaleSlot).doubleValue();
            this.factor = this.factor * this.factor * this.factor;
            if (tc.getAxisState(this.scaleSlot).isReleased()) {
                this.isScaling = false;
                this.removeCurrentSlot(this.timerSlot);
                return;
            }
            if (!this.isScaling) {
                this.isScaling = true;
                this.addCurrentSlot(this.timerSlot);
            }
            return;
        }
        SceneGraphComponent ship = tc.getRootToToolComponent().getLastComponent();
        Matrix shipMatrix = new Matrix();
        if (ship.getTransformation() != null) {
            shipMatrix.assignFrom(ship.getTransformation());
        }
        double dt = (double)tc.getAxisState(this.timerSlot).intValue() * 0.001;
        MatrixBuilder.euclidean(shipMatrix).scale(1.0 + this.factor * dt * this.gain).assignTo(ship);
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }
}

