/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.data.Attribute;
import java.util.EventObject;

public class LineDragEvent
extends EventObject {
    private static final long serialVersionUID = 19823L;
    private final int index;
    private final double[] translation;
    private final double[] position;
    private final IndexedLineSet lineSet;

    public LineDragEvent(IndexedLineSet lineSet, int index, double[] translation, double[] position) {
        super(lineSet);
        this.lineSet = lineSet;
        this.index = index;
        this.translation = (double[])translation.clone();
        this.position = (double[])position.clone();
    }

    public double getX() {
        return this.translation[0];
    }

    public double getY() {
        return this.translation[1];
    }

    public double getZ() {
        return this.translation[2];
    }

    public double[] getTranslation() {
        return (double[])this.translation.clone();
    }

    public double[] getPosition() {
        return (double[])this.position.clone();
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getLineIndices() {
        return this.lineSet.getEdgeAttributes(Attribute.INDICES).toIntArrayArray().getValueAt(this.index).toIntArray(null);
    }

    public double[][] getLineVertices() {
        int[] lineIndices = this.getLineIndices();
        double[][] lineVertices = new double[lineIndices.length][];
        for (int i = 0; i < lineIndices.length; ++i) {
            lineVertices[i] = this.lineSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(lineIndices[i]).toDoubleArray(null);
        }
        return lineVertices;
    }

    public IndexedLineSet getIndexedLineSet() {
        return this.lineSet;
    }
}

