/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.toolsystem.ToolUtility;
import de.jreality.util.LoggingSystem;

public class FlyTool
extends AbstractTool {
    private final transient InputSlot forwardBackwardSlot = InputSlot.getDevice("ForwardBackwardAxis");
    private final transient InputSlot leftRightSlot = InputSlot.getDevice("LeftRightAxis");
    private final transient InputSlot timerSlot = InputSlot.getDevice("SystemTime");
    private transient double velocity;
    private transient boolean isFlying;
    private double[] olddir = new double[]{0.0, 0.0, -1.0, 0.0};
    private double gain = 1.0;
    private double dGain = 1.1;
    private boolean raiseToThirdPower = true;
    EffectiveAppearance eap;

    public FlyTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.forwardBackwardSlot);
        this.addCurrentSlot(this.leftRightSlot);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == this.forwardBackwardSlot) {
            this.velocity = tc.getAxisState(this.forwardBackwardSlot).doubleValue();
            if (this.raiseToThirdPower) {
                this.velocity = this.velocity * this.velocity * this.velocity;
            }
            if (tc.getAxisState(this.forwardBackwardSlot).isReleased()) {
                this.isFlying = false;
                this.removeCurrentSlot(this.timerSlot);
                return;
            }
            if (!this.isFlying) {
                this.isFlying = true;
                this.addCurrentSlot(this.timerSlot);
            }
            return;
        }
        if (tc.getSource() == this.leftRightSlot) {
            double changer = tc.getAxisState(this.leftRightSlot).doubleValue();
            if (changer == 0.0) {
                return;
            }
            this.gain *= changer < 0.0 ? 1.0 / this.dGain : this.dGain;
            System.err.println("Gain is " + this.gain);
            return;
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        int metric = this.eap.getAttribute("metric", 0);
        LoggingSystem.getLogger(this).fine("metric is " + metric);
        SceneGraphComponent ship = tc.getRootToToolComponent().getLastComponent();
        Matrix pointerMatrix = new Matrix(tc.getTransformationMatrix(InputSlot.getDevice("PointerTransformation")));
        Matrix localPointer = ToolUtility.worldToTool(tc, pointerMatrix);
        double[] dir = localPointer.getColumn(2);
        if (metric != 0) {
            Pn.normalize(dir, dir, metric);
            if (Rn.innerProduct(dir, this.olddir) < 0.0) {
                for (int i = 0; i < 4; ++i) {
                    dir[i] = -dir[i];
                }
            }
        }
        double[] shipPosition = localPointer.getColumn(3);
        Matrix shipMatrix = new Matrix();
        if (ship.getTransformation() != null) {
            shipMatrix.assignFrom(ship.getTransformation());
        }
        double val = (double)tc.getAxisState(this.timerSlot).intValue() * 0.001;
        val = val * this.gain * this.velocity;
        double[] newShipPosition = Pn.dragTowards(null, shipPosition, dir, val, metric);
        MatrixBuilder.init(shipMatrix, metric).translateFromTo(shipPosition, newShipPosition).assignTo(ship);
        ship.getTransformation().setMatrix(P3.orthonormalizeMatrix(null, ship.getTransformation().getMatrix(), 1.0E-9, metric));
        tc.getViewer().render();
        System.arraycopy(dir, 0, this.olddir, 0, 4);
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }
}

