/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.FaceDragEvent;
import de.jreality.tools.FaceDragEventMulticaster;
import de.jreality.tools.FaceDragListener;
import de.jreality.tools.LineDragEvent;
import de.jreality.tools.LineDragEventMulticaster;
import de.jreality.tools.LineDragListener;
import de.jreality.tools.PointDragEvent;
import de.jreality.tools.PointDragEventMulticaster;
import de.jreality.tools.PointDragListener;
import de.jreality.tools.PrimitiveDragEvent;
import de.jreality.tools.PrimitiveDragEventMulticaster;
import de.jreality.tools.PrimitiveDragListener;

public class DragEventTool
extends AbstractTool {
    protected PointDragListener pointDragListener;
    protected LineDragListener lineDragListener;
    protected FaceDragListener faceDragListener;
    protected PrimitiveDragListener primitiveDragListener;
    private static final InputSlot pointerSlot = InputSlot.getDevice("PointerTransformation");
    private static InputSlot alongZPointerSlot = InputSlot.getDevice("DragAlongViewDirection");
    protected boolean active;
    private boolean dragInViewDirection;
    protected Geometry geom;
    protected PointSet pointSet;
    protected IndexedLineSet lineSet;
    protected IndexedFaceSet faceSet;
    protected int index = -1;
    protected double[] pickPoint = new double[4];
    private int pickType = 0;
    private Matrix pointerToPoint = new Matrix();
    private final double[][] dir2ScaleZDrag = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private double[][] distDir = new double[this.dir2ScaleZDrag.length][this.dir2ScaleZDrag[0].length];
    private Matrix result = new Matrix();

    public DragEventTool(String dragSlotName) {
        super(InputSlot.getDevice(dragSlotName));
        this.addCurrentSlot(pointerSlot, "triggers drag events");
        this.addCurrentSlot(alongZPointerSlot);
    }

    public DragEventTool(InputSlot ... activationSlots) {
        super(activationSlots);
        this.addCurrentSlot(pointerSlot, "triggers drag events");
        this.addCurrentSlot(alongZPointerSlot);
    }

    public DragEventTool() {
        this("AllDragActivation");
    }

    public void activate(ToolContext tc) {
        this.active = true;
        try {
            this.dragInViewDirection = tc.getAxisState(alongZPointerSlot).isPressed();
        }
        catch (Exception me) {
            this.dragInViewDirection = false;
        }
        tc.getTransformationMatrix(pointerSlot).toDoubleArray(this.pointerToPoint.getArray());
        this.pointerToPoint.invert();
        this.pointerToPoint.multiplyOnRight(tc.getRootToLocal().getMatrix(null));
        Matrix root2cam = new Matrix(tc.getViewer().getCameraPath().getMatrix(null));
        root2cam.setColumn(3, new double[]{0.0, 0.0, 0.0, 1.0});
        this.distDir[0] = Rn.normalize(null, root2cam.multiplyVector(this.dir2ScaleZDrag[0]));
        this.distDir[1] = Rn.normalize(null, root2cam.multiplyVector(this.dir2ScaleZDrag[1]));
        PickResult currentPick = tc.getCurrentPick();
        if (currentPick == null) {
            tc.reject();
            this.active = false;
            return;
        }
        if (currentPick.getPickType() == 0) {
            if (this.primitiveDragListener == null) {
                this.active = false;
                tc.reject();
                return;
            }
            this.pickType = 0;
            this.geom = (Geometry)currentPick.getPickPath().getLastElement();
            double[] pickPointTemp = currentPick.getObjectCoordinates();
            if (pickPointTemp.length == 3) {
                Pn.homogenize(this.pickPoint, pickPointTemp);
            } else {
                Pn.dehomogenize(this.pickPoint, pickPointTemp);
            }
            MatrixBuilder.euclidean(this.pointerToPoint).translate(this.pickPoint);
            this.firePrimitiveDragStart(new double[]{0.0, 0.0, 0.0, 1.0});
        } else if (currentPick.getPickType() == 4) {
            if (this.pointDragListener == null) {
                this.active = false;
                tc.reject();
                return;
            }
            this.pickType = 4;
            this.pointSet = (PointSet)currentPick.getPickPath().getLastElement();
            this.index = currentPick.getIndex();
            double[] pickPointTemp = this.pointSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(this.index).toDoubleArray(null);
            if (pickPointTemp.length == 3) {
                Pn.homogenize(this.pickPoint, pickPointTemp);
            } else {
                Pn.dehomogenize(this.pickPoint, pickPointTemp);
            }
            MatrixBuilder.euclidean(this.pointerToPoint).translate(this.pickPoint);
            this.firePointDragStart(this.pickPoint);
        } else if (currentPick.getPickType() == 2) {
            if (this.lineDragListener == null) {
                this.active = false;
                tc.reject();
                return;
            }
            this.pickType = 2;
            this.lineSet = (IndexedLineSet)currentPick.getPickPath().getLastElement();
            this.index = currentPick.getIndex();
            double[] pickPointTemp = currentPick.getObjectCoordinates();
            if (pickPointTemp.length == 3) {
                Pn.homogenize(this.pickPoint, pickPointTemp);
            } else {
                Pn.dehomogenize(this.pickPoint, pickPointTemp);
            }
            MatrixBuilder.euclidean(this.pointerToPoint).translate(this.pickPoint);
            this.fireLineDragStart(new double[]{0.0, 0.0, 0.0, 1.0}, this.pickPoint);
        } else if (currentPick.getPickType() == 1) {
            if (this.faceDragListener == null) {
                this.active = false;
                tc.reject();
                return;
            }
            this.pickType = 1;
            this.faceSet = (IndexedFaceSet)currentPick.getPickPath().getLastElement();
            this.index = currentPick.getIndex();
            double[] pickPointTemp = currentPick.getObjectCoordinates();
            if (pickPointTemp.length == 3) {
                Pn.homogenize(this.pickPoint, pickPointTemp);
            } else {
                Pn.dehomogenize(this.pickPoint, pickPointTemp);
            }
            MatrixBuilder.euclidean(this.pointerToPoint).translate(this.pickPoint);
            this.fireFaceDragStart(new double[]{0.0, 0.0, 0.0, 1.0}, this.pickPoint);
        } else {
            this.active = false;
            tc.reject();
        }
    }

    public void perform(ToolContext tc) {
        if (!this.active) {
            return;
        }
        tc.getTransformationMatrix(pointerSlot).toDoubleArray(this.result.getArray());
        this.result.multiplyOnRight(this.pointerToPoint);
        this.result.multiplyOnLeft(tc.getRootToLocal().getInverseMatrix(null));
        double[] newPoint3 = new double[3];
        Pn.dehomogenize(newPoint3, this.result.getColumn(3));
        double[] pickPoint3 = new double[3];
        Pn.dehomogenize(pickPoint3, this.pickPoint);
        double[] translation3 = Rn.subtract(null, newPoint3, pickPoint3);
        if (this.dragInViewDirection) {
            double[] dir = new double[3];
            Pn.dehomogenize(dir, this.pointerToPoint.getInverse().getColumn(2));
            Rn.normalize(dir, dir);
            Matrix root2local = new Matrix(tc.getRootToLocal().getMatrix(null));
            root2local.setColumn(3, new double[]{0.0, 0.0, 0.0, 1.0});
            Pn.dehomogenize(translation3, root2local.multiplyVector(Pn.homogenize(null, translation3)));
            double factor = Rn.innerProduct(this.distDir[0], translation3) + Rn.innerProduct(this.distDir[1], translation3);
            Rn.times(translation3, factor /= Rn.euclideanNorm(root2local.multiplyVector(dir)), dir);
        }
        double[] translation = new double[]{translation3[0], translation3[1], translation3[2], 1.0};
        double[] position = new double[4];
        if (this.pickType == 0) {
            this.firePrimitiveDragged(Rn.add(translation, translation, this.pickPoint));
        } else if (this.pickType == 4) {
            this.firePointDragged(Rn.add(translation, translation, this.pickPoint));
        } else if (this.pickType == 2) {
            this.fireLineDragged(translation, Rn.add(position, translation, this.pickPoint));
        } else if (this.pickType == 1) {
            this.fireFaceDragged(translation, Rn.add(position, translation, this.pickPoint));
        }
    }

    public void deactivate(ToolContext tc) {
        if (!this.active) {
            return;
        }
        if (this.pickType == 0) {
            this.firePrimitiveDragEnd(this.pickPoint);
        } else if (this.pickType == 4) {
            this.firePointDragEnd(this.pickPoint);
        } else if (this.pickType == 2) {
            this.fireLineDragEnd(new double[]{0.0, 0.0, 0.0, 1.0}, new double[]{0.0, 0.0, 0.0, 1.0});
        } else if (this.pickType == 1) {
            this.fireFaceDragEnd(new double[]{0.0, 0.0, 0.0, 1.0}, new double[]{0.0, 0.0, 0.0, 1.0});
        }
        this.index = -1;
        this.pointSet = null;
        this.lineSet = null;
        this.faceSet = null;
        this.active = false;
        this.result = new Matrix();
        this.pickType = 0;
    }

    public void addPrimitiveDragListener(PrimitiveDragListener listener) {
        this.primitiveDragListener = PrimitiveDragEventMulticaster.add(this.primitiveDragListener, listener);
    }

    public void removePrimitiveDragListener(PrimitiveDragListener listener) {
        this.primitiveDragListener = PrimitiveDragEventMulticaster.remove(this.primitiveDragListener, listener);
    }

    public void addPointDragListener(PointDragListener listener) {
        this.pointDragListener = PointDragEventMulticaster.add(this.pointDragListener, listener);
    }

    public void removePointDragListener(PointDragListener listener) {
        this.pointDragListener = PointDragEventMulticaster.remove(this.pointDragListener, listener);
    }

    public void addLineDragListener(LineDragListener listener) {
        this.lineDragListener = LineDragEventMulticaster.add(this.lineDragListener, listener);
    }

    public void removeLineDragListener(LineDragListener listener) {
        this.lineDragListener = LineDragEventMulticaster.remove(this.lineDragListener, listener);
    }

    public void addFaceDragListener(FaceDragListener listener) {
        this.faceDragListener = FaceDragEventMulticaster.add(this.faceDragListener, listener);
    }

    public void removeFaceDragListener(FaceDragListener listener) {
        this.faceDragListener = FaceDragEventMulticaster.remove(this.faceDragListener, listener);
    }

    protected void firePrimitiveDragStart(double[] position) {
        PrimitiveDragListener l = this.primitiveDragListener;
        if (l != null) {
            l.primitiveDragStart(new PrimitiveDragEvent(this.geom, position));
        }
    }

    protected void firePrimitiveDragged(double[] position) {
        PrimitiveDragListener l = this.primitiveDragListener;
        if (l != null) {
            l.primitiveDragged(new PrimitiveDragEvent(this.geom, position));
        }
    }

    protected void firePrimitiveDragEnd(double[] position) {
        PrimitiveDragListener l = this.primitiveDragListener;
        if (l != null) {
            l.primitiveDragEnd(new PrimitiveDragEvent(this.geom, position));
        }
    }

    protected void firePointDragStart(double[] location) {
        PointDragListener l = this.pointDragListener;
        if (l != null) {
            l.pointDragStart(new PointDragEvent(this.pointSet, this.index, location));
        }
    }

    protected void firePointDragged(double[] location) {
        PointDragListener l = this.pointDragListener;
        if (l != null) {
            l.pointDragged(new PointDragEvent(this.pointSet, this.index, location));
        }
    }

    protected void firePointDragEnd(double[] location) {
        PointDragListener l = this.pointDragListener;
        if (l != null) {
            l.pointDragEnd(new PointDragEvent(this.pointSet, this.index, location));
        }
    }

    protected void fireLineDragStart(double[] translation, double[] position) {
        LineDragListener l = this.lineDragListener;
        if (l != null) {
            l.lineDragStart(new LineDragEvent(this.lineSet, this.index, translation, position));
        }
    }

    protected void fireLineDragged(double[] translation, double[] position) {
        LineDragListener l = this.lineDragListener;
        if (l != null) {
            l.lineDragged(new LineDragEvent(this.lineSet, this.index, translation, position));
        }
    }

    protected void fireLineDragEnd(double[] translation, double[] position) {
        LineDragListener l = this.lineDragListener;
        if (l != null) {
            l.lineDragEnd(new LineDragEvent(this.lineSet, this.index, translation, position));
        }
    }

    protected void fireFaceDragStart(double[] translation, double[] position) {
        FaceDragListener l = this.faceDragListener;
        if (l != null) {
            l.faceDragStart(new FaceDragEvent(this.faceSet, this.index, translation, position));
        }
    }

    protected void fireFaceDragged(double[] translation, double[] position) {
        FaceDragListener l = this.faceDragListener;
        if (l != null) {
            l.faceDragged(new FaceDragEvent(this.faceSet, this.index, translation, position));
        }
    }

    protected void fireFaceDragEnd(double[] translation, double[] position) {
        FaceDragListener l = this.faceDragListener;
        if (l != null) {
            l.faceDragEnd(new FaceDragEvent(this.faceSet, this.index, translation, position));
        }
    }
}

