/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing.jrwindows;

import de.jreality.backends.label.LabelUtility;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.Tool;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import de.jreality.swing.JFakeFrame;
import de.jreality.tools.ActionTool;
import de.jreality.util.Secure;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JRWindow {
    private int windowNumber;
    private boolean enableVertexPopUpTool = false;
    private IndexedFaceSet frameFace;
    private IndexedLineSet borders;
    private IndexedFaceSet decoControlFace;
    private IndexedFaceSet decoDragFace;
    private JFakeFrame frame;
    private JFrame externalFrame = new JFrame();
    private boolean inScene = true;
    ActionTool myActionTool = new ActionTool("PanelActivation");
    private Tool mouseEventTool;
    private Tool vertexPopUpTool;
    private SceneGraphComponent sgc;
    private SceneGraphComponent positionSgc;
    private SceneGraphComponent frameSgc;
    private SceneGraphComponent borderSgc;
    private SceneGraphComponent decoControlSgc;
    private SceneGraphComponent decoDragSgc;
    private final double[][] startCornerPos = new double[][]{{1.0, 0.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, -1.0, 0.0}, {-1.0, 0.0, 0.0}};
    private double[][] cornerPos;
    private double[][] cornerPosBak;
    private boolean isSmall = false;
    private double borderRadius = 0.01;
    private double cornerRadius;
    private double cornerRadiusPopUpFactor = 3.0;
    private double translateFactor;
    private double decoHight = 0.08;
    private final double decoControlWidthFactor = 4.0;
    private double decoControlWidth;
    private double aspectRatio = 1.0;
    private double[][] faceCorners;
    private double[][] decoControlCorners;
    private double[][] decoDragCorners;
    private double[] smallCenter;
    private JPanel panel;
    private JButton killButton;
    private JButton maxButton;
    private JButton minButton;
    private final Color activeColor = new Color(62, 139, 210);
    private final Color inactiveColor = new Color(138, 182, 225);
    private static final Font TITLE_FONT = new Font("Sans Serif", 1, 24);
    private static final boolean FORBID_EXTERNAL_FRAME = "portal-remote".equals(Secure.getProperty("de.jreality.viewerapp.env"));
    private boolean vertexDragged = false;

    protected JRWindow(int windowNumber) {
        this.myActionTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRWindow.this.getFrame().setVisible(!JRWindow.this.getFrame().isVisible());
                if (!JRWindow.this.isSmall && JRWindow.this.vertexPopUpTool != null && !JRWindow.this.borderSgc.getTools().contains(JRWindow.this.vertexPopUpTool)) {
                    JRWindow.this.borderSgc.addTool(JRWindow.this.vertexPopUpTool);
                }
            }
        });
        this.windowNumber = windowNumber;
        this.setBorderRadius(this.borderRadius);
        this.setDecoSize(this.decoHight);
        this.cornerPos = new double[this.startCornerPos.length][this.startCornerPos[0].length];
        for (int n = 0; n < this.cornerPos.length; ++n) {
            for (int c = 0; c < this.cornerPos[0].length; ++c) {
                this.cornerPos[n][c] = this.startCornerPos[n][c];
            }
        }
        this.cornerPosBak = new double[this.cornerPos.length][this.cornerPos[0].length];
        this.initSgc();
        this.initFrame();
        this.initDecoration();
    }

    private void initSgc() {
        this.positionSgc = new SceneGraphComponent("frame [" + this.windowNumber + "]");
        this.positionSgc.setVisible(false);
        this.positionSgc.setAppearance(new Appearance());
        this.positionSgc.getAppearance().setAttribute("pointShader.pickable", true);
        this.positionSgc.getAppearance().setAttribute("lineShader.pickable", true);
        this.positionSgc.getAppearance().setAttribute("polygonShader.pickable", true);
        this.sgc = new SceneGraphComponent();
        this.positionSgc.addChild(this.sgc);
    }

    private void initFrame() {
        this.frameSgc = new SceneGraphComponent("content");
        this.sgc.addChild(this.frameSgc);
        this.faceCorners = new double[this.cornerPos.length][this.cornerPos[0].length];
        this.calculateFaceCorners(this.faceCorners, this.cornerPos);
        IndexedFaceSetFactory face = new IndexedFaceSetFactory();
        face.setVertexCount(4);
        face.setVertexCoordinates(this.faceCorners);
        face.setVertexTextureCoordinates(new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}});
        face.setFaceCount(1);
        face.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        face.setGenerateEdgesFromFaces(false);
        face.setGenerateFaceNormals(true);
        face.setGenerateVertexNormals(true);
        face.update();
        this.frameFace = face.getIndexedFaceSet();
        this.frame = new JFakeFrame();
        ComponentListener componentListener = new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
                JRWindow.this.getSgc().setVisible(false);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                this.updateAspectRatio();
                JRWindow.this.setCorner(0, JRWindow.this.cornerPos[0]);
            }

            public void componentShown(ComponentEvent e) {
                this.updateAspectRatio();
                if (!JRWindow.this.isSmall) {
                    JRWindow.this.setCorner(0, JRWindow.this.cornerPos[0]);
                } else {
                    JRWindow.this.setSmall(true);
                }
                JRWindow.this.getSgc().setVisible(true);
            }

            void updateAspectRatio() {
                double newAspectRatio = (double)JRWindow.this.frame.getWidth() / (double)JRWindow.this.frame.getHeight();
                if (newAspectRatio == 0.0 || Double.isNaN(newAspectRatio) || Double.isInfinite(newAspectRatio)) {
                    System.out.println("ignoring new aspectRatio: " + newAspectRatio);
                    return;
                }
                JRWindow.this.aspectRatio = newAspectRatio;
            }
        };
        this.frame.addComponentListener(componentListener);
        this.frame.addPropertyChangeListener("title", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JRWindow.this.updateFrameTitle();
                JRWindow.this.externalFrame.setTitle(JRWindow.this.frame.getTitle());
            }
        });
        this.frameSgc.setGeometry(this.frameFace);
        this.frameSgc.addTool(this.frame.getTool());
        this.frameSgc.setAppearance(this.frame.getAppearance());
        this.frameSgc.getAppearance().setAttribute("showPoints", false);
        this.frameSgc.getAppearance().setAttribute("spheresDraw", false);
        this.frameSgc.getAppearance().setAttribute("showLines", false);
        this.frameSgc.getAppearance().setAttribute("tubeDraw", false);
        this.frameSgc.getAppearance().setAttribute("lightingEnabled", false);
    }

    private void initDecoration() {
        this.decoControlSgc = new SceneGraphComponent("controls");
        this.sgc.addChild(this.decoControlSgc);
        this.decoControlCorners = new double[this.cornerPos.length][this.cornerPos[0].length];
        for (int i = 0; i < this.cornerPos.length; ++i) {
            this.decoControlCorners[i][2] = 0.0;
        }
        this.calculateDecoControlCorners(this.decoControlCorners, this.cornerPos);
        IndexedFaceSetFactory decoControlFace = new IndexedFaceSetFactory();
        decoControlFace.setVertexCount(4);
        decoControlFace.setVertexCoordinates(this.decoControlCorners);
        decoControlFace.setVertexTextureCoordinates(new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}});
        decoControlFace.setFaceCount(1);
        decoControlFace.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        decoControlFace.setGenerateEdgesFromFaces(false);
        decoControlFace.setGenerateFaceNormals(true);
        decoControlFace.setGenerateVertexNormals(true);
        decoControlFace.update();
        this.decoControlFace = decoControlFace.getIndexedFaceSet();
        JFakeFrame decoControlFrame = new JFakeFrame();
        this.decoControlSgc.addTool(decoControlFrame.getTool());
        this.decoControlSgc.setAppearance(decoControlFrame.getAppearance());
        this.decoControlSgc.setGeometry(this.decoControlFace);
        this.decoControlSgc.getAppearance().setAttribute("showPoints", false);
        this.decoControlSgc.getAppearance().setAttribute("spheresDraw", false);
        this.decoControlSgc.getAppearance().setAttribute("showLines", false);
        this.decoControlSgc.getAppearance().setAttribute("tubeDraw", false);
        this.decoControlSgc.getAppearance().setAttribute("lineShader.diffuseColor", this.activeColor);
        this.decoControlSgc.getAppearance().setAttribute("lightingEnabled", false);
        this.panel = new JPanel();
        this.panel.setBackground(this.activeColor);
        this.killButton = new JButton("X");
        this.killButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRWindow.this.frame.setVisible(false);
                if (JRWindow.this.vertexPopUpTool != null && !JRWindow.this.borderSgc.getTools().isEmpty() && JRWindow.this.borderSgc.getTools().contains(JRWindow.this.vertexPopUpTool)) {
                    JRWindow.this.borderSgc.removeTool(JRWindow.this.vertexPopUpTool);
                }
            }
        });
        this.maxButton = new JButton("O");
        this.maxButton.setEnabled(false);
        this.minButton = new JButton("_");
        this.minButton.setEnabled(true);
        this.panel.add(this.minButton);
        this.panel.add(this.maxButton);
        this.panel.add(this.killButton);
        decoControlFrame.getContentPane().add(this.panel);
        decoControlFrame.pack();
        decoControlFrame.setVisible(true);
        this.decoDragSgc = new SceneGraphComponent("title");
        this.sgc.addChild(this.decoDragSgc);
        this.decoDragCorners = new double[this.cornerPos.length][this.cornerPos[0].length];
        for (int i = 0; i < this.cornerPos.length; ++i) {
            this.decoDragCorners[i][2] = 0.0;
        }
        this.calculateDecoDragCorners(this.decoDragCorners, this.cornerPos);
        IndexedFaceSetFactory decoDragFace = new IndexedFaceSetFactory();
        decoDragFace.setVertexCount(4);
        decoDragFace.setVertexCoordinates(this.decoDragCorners);
        decoDragFace.setVertexTextureCoordinates(new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}});
        decoDragFace.setFaceCount(1);
        decoDragFace.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        decoDragFace.setGenerateEdgesFromFaces(false);
        decoDragFace.setGenerateFaceNormals(true);
        decoDragFace.setGenerateVertexNormals(true);
        decoDragFace.update();
        this.decoDragFace = decoDragFace.getIndexedFaceSet();
        this.decoDragSgc.setGeometry(this.decoDragFace);
        this.decoDragSgc.setAppearance(new Appearance());
        this.decoDragSgc.getAppearance().setAttribute("showPoints", false);
        this.decoDragSgc.getAppearance().setAttribute("spheresDraw", false);
        this.decoDragSgc.getAppearance().setAttribute("showLines", false);
        this.decoDragSgc.getAppearance().setAttribute("tubeDraw", false);
        this.decoDragSgc.getAppearance().setAttribute("lineShader.diffuseColor", this.activeColor);
        this.decoDragSgc.getAppearance().setAttribute("lightingEnabled", false);
        this.borderSgc = new SceneGraphComponent("border");
        this.sgc.addChild(this.borderSgc);
        IndexedLineSetFactory borders = new IndexedLineSetFactory();
        borders.setVertexCount(4);
        borders.setVertexCoordinates(this.cornerPos);
        borders.setEdgeCount(4);
        borders.setEdgeIndices(new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}});
        borders.update();
        this.borders = borders.getIndexedLineSet();
        this.borderSgc.setGeometry(this.borders);
        this.borderSgc.setAppearance(new Appearance());
        this.borderSgc.getAppearance().setAttribute("showPoints", true);
        this.borderSgc.getAppearance().setAttribute("spheresDraw", true);
        this.borderSgc.getAppearance().setAttribute("showLines", true);
        this.borderSgc.getAppearance().setAttribute("tubeDraw", true);
        this.borderSgc.getAppearance().setAttribute("lineShader.diffuseColor", this.activeColor);
        this.borderSgc.getAppearance().setAttribute("pointShader.diffuseColor", this.activeColor);
        this.borderSgc.getAppearance().setAttribute("pointRadius", this.cornerRadius);
        this.borderSgc.getAppearance().setAttribute("tubeRadius", this.borderRadius);
        this.borderSgc.getAppearance().setAttribute("lightingEnabled", true);
        if (this.enableVertexPopUpTool) {
            this.enableVertexPopUpTool(true);
        }
    }

    protected void updateFrameTitle() {
        double width;
        double height;
        BufferedImage img = LabelUtility.createImageFromString(this.frame.getTitle(), TITLE_FONT, Color.black, Color.white);
        double w = img.getWidth();
        double h = (double)img.getHeight() * 1.5;
        double lambda = h / (height = this.decoDragCorners[0][1] - this.decoDragCorners[2][1]);
        double effW = lambda * (width = this.decoDragCorners[0][0] - this.decoDragCorners[2][0]);
        if (effW <= w + h / 3.0) {
            effW = w + h / 3.0;
        }
        BufferedImage effImg = new BufferedImage((int)effW, (int)h, 2);
        effImg.getGraphics().fillRect(0, 0, effImg.getWidth(), effImg.getHeight());
        effImg.getGraphics().drawImage(img, (int)(h / 6.0), (int)(h / 6.0), null);
        TextureUtility.createTexture(this.decoDragSgc.getAppearance(), "polygonShader", new ImageData(effImg));
    }

    protected void addActionListeners(ActionListener actionListener) {
        this.maxButton.addActionListener(actionListener);
        this.minButton.addActionListener(actionListener);
        this.updateActionCommands();
    }

    private void updateActionCommands() {
        this.killButton.setActionCommand("X" + this.windowNumber);
        this.maxButton.setActionCommand("O" + this.windowNumber);
        this.minButton.setActionCommand("_" + this.windowNumber);
    }

    protected void setCornerPos(double[][] newCornerPos) {
        for (int i = 0; i < newCornerPos.length; ++i) {
            newCornerPos[i][2] = 0.0;
        }
        if (newCornerPos[0][0] - newCornerPos[3][0] >= this.decoControlWidth + this.borderRadius && newCornerPos[0][1] - newCornerPos[1][1] >= this.decoHight + this.borderRadius) {
            this.cornerPos = newCornerPos;
        } else if (newCornerPos[0][0] - newCornerPos[3][0] >= this.decoControlWidth + this.borderRadius || newCornerPos[0][1] - newCornerPos[1][1] >= this.decoHight + this.borderRadius) {
            int n;
            if (newCornerPos[0][0] - newCornerPos[3][0] > this.decoControlWidth + this.borderRadius) {
                for (n = 0; n < this.cornerPos.length; ++n) {
                    this.cornerPos[n][0] = newCornerPos[n][0];
                }
            } else if (newCornerPos[0][1] - newCornerPos[1][1] > this.decoHight + this.borderRadius) {
                for (n = 0; n < this.cornerPos.length; ++n) {
                    this.cornerPos[n][1] = newCornerPos[n][1];
                }
            }
        } else {
            return;
        }
        double centerX = (this.cornerPos[3][0] + this.cornerPos[0][0]) / 2.0;
        MatrixBuilder.euclidean().rotateY(-0.2 * centerX).translate(0.0, 0.0, -0.3 * centerX * centerX).assignTo(this.sgc);
        this.calculateFaceCorners(this.faceCorners, this.cornerPos);
        this.frameFace.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(this.faceCorners));
        this.calculateDecoControlCorners(this.decoControlCorners, this.cornerPos);
        this.decoControlFace.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(this.decoControlCorners));
        this.calculateDecoDragCorners(this.decoDragCorners, this.cornerPos);
        this.decoDragFace.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(this.decoDragCorners));
        this.borders.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(this.cornerPos));
        this.updateFrameTitle();
    }

    public void resize(double factor) {
        double[] c1 = this.cornerPos[0];
        double[] c2 = this.cornerPos[2];
        double[] diag = Rn.subtract(null, c2, c1);
        Rn.times(diag, factor, diag);
        Rn.add(diag, diag, c1);
        this.setCorner(2, diag);
    }

    void setCorner(int cornerIndex, double[] newPoint) {
        int oppositeCorner = (cornerIndex + 2) % 4;
        newPoint[1] = newPoint[1] - this.decoHight;
        newPoint[2] = 0.0;
        double[] diag = Rn.subtract(null, newPoint, this.cornerPos[oppositeCorner]);
        double newAsp = Math.abs(diag[0] / diag[1]);
        if (newAsp > this.aspectRatio) {
            diag[0] = Math.signum(diag[0]) * this.aspectRatio * Math.abs(diag[1]);
        } else {
            diag[1] = Math.signum(diag[1]) * Math.abs(diag[0]) / this.aspectRatio;
        }
        double decoWidth = Math.abs(this.decoControlCorners[2][0] - this.decoControlCorners[0][0]);
        if (Math.abs(diag[0]) < decoWidth) {
            double f = decoWidth / Math.abs(diag[0]);
            diag[0] = diag[0] * f;
            diag[1] = diag[1] * f;
        }
        if (cornerIndex == 0 && (diag[0] <= 0.0 || diag[1] <= 0.0)) {
            return;
        }
        if (cornerIndex == 1 && (diag[0] <= 0.0 || diag[1] >= 0.0)) {
            return;
        }
        if (cornerIndex == 2 && (diag[0] >= 0.0 || diag[1] >= 0.0)) {
            return;
        }
        if (cornerIndex == 3 && (diag[0] >= 0.0 || diag[1] <= 0.0)) {
            return;
        }
        Rn.add(this.cornerPos[cornerIndex], this.cornerPos[oppositeCorner], diag);
        if (cornerIndex == 3 || cornerIndex == 0) {
            double[] dArray = this.cornerPos[cornerIndex];
            dArray[1] = dArray[1] + this.decoHight;
        } else {
            double[] dArray = this.cornerPos[cornerIndex];
            dArray[1] = dArray[1] - this.decoHight;
        }
        int nextCorner = (cornerIndex + 1) % 4;
        int prevCorner = (cornerIndex - 1 + 4) % 4;
        if (cornerIndex % 2 == 0) {
            this.cornerPos[nextCorner][0] = this.cornerPos[cornerIndex][0];
            this.cornerPos[prevCorner][1] = this.cornerPos[cornerIndex][1];
        } else {
            this.cornerPos[nextCorner][1] = this.cornerPos[cornerIndex][1];
            this.cornerPos[prevCorner][0] = this.cornerPos[cornerIndex][0];
        }
        this.setCornerPos(this.cornerPos);
    }

    private void calculateFaceCorners(double[][] faceCorners, double[][] cornerPos) {
        faceCorners[0][0] = cornerPos[0][0];
        faceCorners[0][1] = cornerPos[0][1] - this.decoHight;
        faceCorners[1][0] = cornerPos[1][0];
        faceCorners[1][1] = cornerPos[1][1];
        faceCorners[2][0] = cornerPos[2][0];
        faceCorners[2][1] = cornerPos[2][1];
        faceCorners[3][0] = cornerPos[3][0];
        faceCorners[3][1] = cornerPos[3][1] - this.decoHight;
    }

    private void calculateDecoControlCorners(double[][] decoControlCorners, double[][] cornerPos) {
        decoControlCorners[0][0] = cornerPos[0][0];
        decoControlCorners[0][1] = cornerPos[0][1];
        decoControlCorners[1][0] = cornerPos[0][0];
        decoControlCorners[1][1] = cornerPos[0][1] - this.decoHight;
        decoControlCorners[2][0] = cornerPos[0][0] - this.decoControlWidth;
        decoControlCorners[2][1] = cornerPos[0][1] - this.decoHight;
        decoControlCorners[3][0] = cornerPos[0][0] - this.decoControlWidth;
        decoControlCorners[3][1] = cornerPos[0][1];
    }

    private void calculateDecoDragCorners(double[][] decoDragCorners, double[][] cornerPos) {
        decoDragCorners[0][0] = cornerPos[0][0] - this.decoControlWidth;
        decoDragCorners[0][1] = cornerPos[0][1];
        decoDragCorners[1][0] = cornerPos[1][0] - this.decoControlWidth;
        decoDragCorners[1][1] = cornerPos[0][1] - this.decoHight;
        decoDragCorners[2][0] = cornerPos[2][0];
        decoDragCorners[2][1] = cornerPos[3][1] - this.decoHight;
        decoDragCorners[3][0] = cornerPos[3][0];
        decoDragCorners[3][1] = cornerPos[3][1];
    }

    protected double[][] getCornerPos() {
        return this.cornerPos;
    }

    protected void setSmall(boolean setSmall) {
        if (setSmall && !this.isSmall) {
            for (int i = 0; i < this.cornerPos.length; ++i) {
                Rn.copy(this.cornerPosBak[i], this.cornerPos[i]);
            }
            if (this.smallCenter == null) {
                this.smallCenter = this.getCenter(this.cornerPos);
            }
            double factorX = (this.decoControlWidth + this.borderRadius) / 2.0;
            double factorY = factorX * Rn.euclideanDistance(this.cornerPos[0], this.cornerPos[1]) / Rn.euclideanDistance(this.cornerPos[0], this.cornerPos[3]);
            this.cornerPos[0][0] = this.smallCenter[0] + factorX;
            this.cornerPos[0][1] = this.smallCenter[1] + factorY;
            this.cornerPos[1][0] = this.smallCenter[0] + factorX;
            this.cornerPos[1][1] = this.smallCenter[1] - factorY;
            this.cornerPos[2][0] = this.smallCenter[0] - factorX;
            this.cornerPos[2][1] = this.smallCenter[1] - factorY;
            this.cornerPos[3][0] = this.smallCenter[0] - factorX;
            this.cornerPos[3][1] = this.smallCenter[1] + factorY;
            this.mouseEventTool = this.frameSgc.getTools().get(0);
            this.frameSgc.removeTool(this.mouseEventTool);
            if (this.vertexPopUpTool != null) {
                this.borderSgc.removeTool(this.vertexPopUpTool);
            }
            this.setActiveColor(false);
            this.minButton.setEnabled(false);
            this.maxButton.setEnabled(true);
            this.isSmall = true;
        } else if (!setSmall && this.isSmall) {
            this.smallCenter = this.getCenter(this.cornerPos);
            for (int i = 0; i < this.cornerPos.length; ++i) {
                Rn.copy(this.cornerPos[i], this.cornerPosBak[i]);
            }
            if (this.mouseEventTool != null) {
                this.frameSgc.addTool(this.mouseEventTool);
            }
            if (this.vertexPopUpTool != null) {
                this.borderSgc.addTool(this.vertexPopUpTool);
            }
            this.setActiveColor(true);
            this.minButton.setEnabled(true);
            this.maxButton.setEnabled(false);
            this.isSmall = false;
        }
        this.setCornerPos(this.cornerPos);
    }

    private double[] getCenter(double[][] box) {
        double[] center = new double[]{0.0, 0.0, 0.0};
        for (int n = 0; n < box.length; ++n) {
            Rn.add(center, center, box[n]);
        }
        Rn.times(center, 1.0 / (double)box.length, center);
        return center;
    }

    protected boolean isSmall() {
        return this.isSmall;
    }

    protected void setInFront(boolean setInFront) {
        if (setInFront) {
            if (!this.isSmall) {
                this.setActiveColor(true);
            }
            MatrixBuilder.euclidean().assignTo(this.positionSgc);
        } else {
            if (!this.isSmall) {
                this.setActiveColor(false);
            }
            MatrixBuilder.euclidean().translate(0.0, 0.0, -this.translateFactor * (double)(this.windowNumber + 1)).assignTo(this.positionSgc);
        }
    }

    private void setActiveColor(boolean active) {
        if (active) {
            this.decoDragSgc.getAppearance().setAttribute("polygonShader.diffuseColor", this.activeColor);
            this.borderSgc.getAppearance().setAttribute("lineShader.polygonShader.diffuseColor", this.activeColor);
            this.borderSgc.getAppearance().setAttribute("pointShader.polygonShader.diffuseColor", this.activeColor);
            this.panel.setBackground(this.activeColor);
        } else {
            this.decoDragSgc.getAppearance().setAttribute("polygonShader.diffuseColor", this.inactiveColor);
            this.borderSgc.getAppearance().setAttribute("lineShader.polygonShader.diffuseColor", this.inactiveColor);
            this.borderSgc.getAppearance().setAttribute("pointShader.polygonShader.diffuseColor", this.inactiveColor);
            this.panel.setBackground(this.inactiveColor);
        }
    }

    protected void setBorderRadius(double r) {
        this.borderRadius = r;
        this.cornerRadius = this.borderRadius * 1.75;
        this.translateFactor = 1.1 * this.cornerRadius;
        if (this.borderSgc != null) {
            this.borderSgc.getAppearance().setAttribute("pointRadius", this.cornerRadius);
            this.borderSgc.getAppearance().setAttribute("tubeRadius", this.borderRadius);
            this.setCornerPos(this.cornerPos);
        }
    }

    protected void setDecoSize(double s) {
        this.decoHight = s;
        this.decoControlWidth = s * 4.0;
        if (this.borderSgc != null) {
            this.setCornerPos(this.cornerPos);
        }
    }

    protected void setWindowNumber(int windowNumber) {
        this.windowNumber = windowNumber;
        this.updateActionCommands();
    }

    protected int getWindowNumber() {
        return this.windowNumber;
    }

    protected SceneGraphComponent getSgc() {
        return this.positionSgc;
    }

    public JFrame getFrame() {
        return this.inScene ? this.frame : this.externalFrame;
    }

    protected IndexedFaceSet getFrameFace() {
        return this.frameFace;
    }

    protected IndexedFaceSet getDecoControlFace() {
        return this.decoControlFace;
    }

    protected IndexedFaceSet getDecoDragFace() {
        return this.decoDragFace;
    }

    protected IndexedLineSet getBorders() {
        return this.borders;
    }

    public void setInScene(boolean b) {
        if (FORBID_EXTERNAL_FRAME) {
            return;
        }
        if (b == this.inScene) {
            return;
        }
        if (b) {
            this.inScene = b;
            boolean visible = this.externalFrame.isVisible();
            this.externalFrame.setVisible(false);
            this.frame.setContentPane(this.externalFrame.getContentPane());
            this.externalFrame.remove(this.externalFrame.getContentPane());
            this.frame.pack();
            this.frame.setVisible(visible);
        } else {
            this.getSgc().setVisible(false);
            boolean visible = this.frame.isVisible();
            this.frame.setVisible(false);
            this.inScene = b;
            this.externalFrame.setContentPane(this.frame.getContentPane());
            this.frame.remove(this.frame.getContentPane());
            this.externalFrame.pack();
            this.externalFrame.setVisible(visible);
        }
    }

    public ActionTool getPanelTool() {
        return this.myActionTool;
    }

    protected void popUpDragVertices(boolean popUp) {
        this.borderSgc.getAppearance().setAttribute("pointRadius", popUp ? this.cornerRadius * this.cornerRadiusPopUpFactor : this.cornerRadius);
    }

    protected void setVertexDragged(boolean isDragged) {
        this.vertexDragged = isDragged;
    }

    protected void enableVertexPopUpTool(boolean enableVertexPopUpTool) {
        if (enableVertexPopUpTool) {
            if (this.vertexPopUpTool == null) {
                this.vertexPopUpTool = new VertexPopUpTool();
            }
            if (!this.isSmall && !this.borderSgc.getTools().contains(this.vertexPopUpTool)) {
                this.borderSgc.addTool(this.vertexPopUpTool);
            }
        } else if (this.vertexPopUpTool != null && !this.borderSgc.getTools().isEmpty() && this.borderSgc.getTools().contains(this.vertexPopUpTool)) {
            this.borderSgc.removeTool(this.vertexPopUpTool);
        }
        this.enableVertexPopUpTool = enableVertexPopUpTool;
    }

    private class VertexPopUpTool
    extends AbstractTool {
        private final InputSlot pointer;

        protected VertexPopUpTool() {
            super(new InputSlot[]{null});
            this.pointer = InputSlot.getDevice("PointerTransformation");
            this.addCurrentSlot(this.pointer);
        }

        public void perform(ToolContext tc) {
            if (!JRWindow.this.isSmall) {
                PickResult currentPick = tc.getCurrentPick();
                if (currentPick != null) {
                    if (currentPick.getPickPath().getLastComponent() == JRWindow.this.borderSgc) {
                        if (currentPick.getPickType() == 4) {
                            JRWindow.this.popUpDragVertices(true);
                        } else if (!JRWindow.this.vertexDragged) {
                            JRWindow.this.popUpDragVertices(false);
                        }
                    } else if (!JRWindow.this.vertexDragged) {
                        JRWindow.this.popUpDragVertices(false);
                    }
                } else if (!JRWindow.this.vertexDragged) {
                    JRWindow.this.popUpDragVertices(false);
                }
            }
        }
    }
}

