/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.scene.tool.InputSlot;
import de.jreality.tools.DragEventTool;
import de.jreality.tools.FaceDragEvent;
import de.jreality.tools.FaceDragListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PlanarMouseEventTool
extends DragEventTool
implements FaceDragListener {
    private Point oldPoint;
    private Component comp;
    private boolean dispatchLater = false;
    long lastActivationTime;
    private Point newPoint;
    int currentButton = 0;
    boolean doubleClick;
    int doubleClickDelay = 400;

    public PlanarMouseEventTool(InputSlot drag, int buttonID, Component c, boolean dispatchLater) {
        super(drag);
        this.currentButton = buttonID;
        this.comp = c;
        this.dispatchLater = dispatchLater;
        this.addCurrentSlot(InputSlot.getDevice("PointerTransformation"), "moves the mouse pointer");
        super.addFaceDragListener(this);
    }

    public PlanarMouseEventTool(InputSlot drag, int buttonID, Component c) {
        this(drag, buttonID, c, true);
    }

    public void faceDragEnd(FaceDragEvent e) {
        this.dispatchMouseEvent(this.newPoint, 502, this.currentButton);
        if (this.oldPoint.equals(this.newPoint)) {
            this.dispatchMouseEvent(this.newPoint, 500, this.currentButton);
        }
    }

    public void faceDragStart(FaceDragEvent e) {
        long t = System.currentTimeMillis();
        if (t - this.lastActivationTime <= (long)this.doubleClickDelay) {
            this.doubleClick = true;
            this.lastActivationTime = 0L;
        } else {
            this.lastActivationTime = t;
            this.doubleClick = false;
        }
        this.oldPoint = this.newPoint = this.generatePoint(e);
        this.dispatchMouseEvent(this.newPoint, 501, this.currentButton);
    }

    public void faceDragged(FaceDragEvent e) {
        this.newPoint = this.generatePoint(e);
        this.dispatchMouseEvent(this.newPoint, 506, this.currentButton);
    }

    private Point generatePoint(FaceDragEvent e) {
        double[] pos = e.getPosition();
        return new Point((int)pos[0], (int)pos[1]);
    }

    void dispatchMouseEvent(Point newPoint, int type, int button) {
        MouseEvent newEvent = new MouseEvent(this.comp, type, System.currentTimeMillis(), 1 << 10 + button, newPoint.x, newPoint.y, this.doubleClick ? 2 : 1, false, 1 + button);
        this.dispatchEvent(newEvent);
    }

    public void dispatchEvent(final AWTEvent e) {
        if (this.dispatchLater) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PlanarMouseEventTool.this.comp.dispatchEvent(e);
                }
            });
        } else {
            this.comp.dispatchEvent(e);
        }
    }
}

