/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.shader;

import de.jreality.backends.texture.SimpleTexture;
import de.jreality.shader.CubeMap;
import de.jreality.shader.RenderingHintsShader;
import java.awt.Color;
import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point2;
import org.sunflow.math.Vector3;

public class DefaultPolygonShader
implements Shader {
    private de.jreality.shader.DefaultPolygonShader dps;
    private SimpleTexture tex;
    private RenderingHintsShader rhs;
    private CubeMap cm;

    public DefaultPolygonShader(de.jreality.shader.DefaultPolygonShader dps, RenderingHintsShader rhs, boolean hasTextureCoordinates) {
        this.dps = dps;
        if (dps.getTexture2d() != null && hasTextureCoordinates) {
            this.tex = new SimpleTexture(dps.getTexture2d());
        }
        this.rhs = rhs;
        this.cm = dps.getReflectionMap();
    }

    public org.sunflow.image.Color getRadiance(ShadingState state) {
        state.faceforward();
        state.initLightSamples();
        state.initCausticSamples();
        double[] diff = this.getDiffuse(state);
        if (diff[3] == 0.0) {
            return state.traceRefraction(new Ray(state.getPoint(), state.getRay().getDirection()), 0);
        }
        org.sunflow.image.Color d = new org.sunflow.image.Color((float)diff[0], (float)diff[1], (float)diff[2]).toLinear();
        if (!this.rhs.getLightingEnabled().booleanValue()) {
            return d;
        }
        org.sunflow.image.Color ret = state.diffuse(d);
        if (state.includeSpecular()) {
            org.sunflow.image.Color spec = state.specularPhong(this.convert(this.dps.getSpecularColor(), this.dps.getSpecularCoefficient()), this.dps.getSpecularExponent().floatValue(), 0);
            ret.add(spec);
        }
        if (this.cm != null) {
            float cos = state.getCosND();
            float dn = 2.0f * cos;
            Vector3 refDir = new Vector3();
            refDir.x = dn * state.getNormal().x + state.getRay().getDirection().x;
            refDir.y = dn * state.getNormal().y + state.getRay().getDirection().y;
            refDir.z = dn * state.getNormal().z + state.getRay().getDirection().z;
            Ray refRay = new Ray(state.getPoint(), refDir);
            org.sunflow.image.Color ref = state.traceReflection(refRay, 0);
            float l = (float)this.cm.getBlendColor().getAlpha() / 255.0f;
            ret.mul(1.0f - l).madd(l, ref);
        }
        if (diff[3] != 1.0) {
            float t = (float)diff[3];
            org.sunflow.image.Color refl = state.traceRefraction(new Ray(state.getPoint(), state.getRay().getDirection()), 0);
            ret.mul(t).madd(1.0f - t, refl);
        }
        return ret;
    }

    private double[] getDiffuse(ShadingState state) {
        double[] color = new double[4];
        this.getColor(color, this.dps.getDiffuseColor(), this.dps.getDiffuseCoefficient());
        if (this.rhs.getTransparencyEnabled().booleanValue()) {
            color[3] = 1.0 - this.dps.getTransparency();
        } else if (this.dps.getTransparency() == 1.0) {
            color[3] = 0.0;
        }
        if (this.tex != null) {
            Point2 uv = state.getUV();
            this.tex.getColor(uv.x, uv.y, 0.0, 0.0, 0.0, 0, 0, color);
        }
        if (!this.rhs.getTransparencyEnabled().booleanValue() && color[3] > 0.0) {
            color[3] = 1.0;
        }
        return color;
    }

    private void getColor(double[] d, Color c, double f) {
        d[0] = (double)c.getRed() * f / 255.0;
        d[1] = (double)c.getGreen() * f / 255.0;
        d[2] = (double)c.getBlue() * f / 255.0;
        d[3] = c.getAlpha() / 255;
    }

    private org.sunflow.image.Color convert(Color c, double f) {
        float ff = (float)(f / 255.0);
        return new org.sunflow.image.Color((float)c.getRed() * ff, (float)c.getGreen() * ff, (float)c.getBlue() * ff);
    }

    public void scatterPhoton(ShadingState state, org.sunflow.image.Color power) {
        float refl = this.cm != null ? (float)this.cm.getBlendColor().getAlpha() / 255.0f : 0.0f;
        state.faceforward();
        double[] diff = this.getDiffuse(state);
        org.sunflow.image.Color diffuse = new org.sunflow.image.Color((float)diff[0], (float)diff[1], (float)diff[2]);
        state.storePhoton(state.getRay().getDirection(), power, diffuse);
        float d = diffuse.getAverage();
        float r = d * refl;
        double rnd = state.getRandom(0, 0, 1);
        if (rnd < (double)d) {
            power.mul(diffuse).mul(1.0f / d);
            OrthoNormalBasis onb = state.getBasis();
            double u = Math.PI * 2 * rnd / (double)d;
            double v = state.getRandom(0, 1, 1);
            float s = (float)Math.sqrt(v);
            float s1 = (float)Math.sqrt(1.0 - v);
            Vector3 w = new Vector3((float)Math.cos(u) * s, (float)Math.sin(u) * s, s1);
            w = onb.transform(w, new Vector3());
            state.traceDiffusePhoton(new Ray(state.getPoint(), w), power);
        } else if (rnd < (double)(d + r)) {
            float cos = -Vector3.dot((Vector3)state.getNormal(), (Vector3)state.getRay().getDirection());
            power.mul(diffuse).mul(1.0f / d);
            float dn = 2.0f * cos;
            Vector3 dir = new Vector3();
            dir.x = dn * state.getNormal().x + state.getRay().getDirection().x;
            dir.y = dn * state.getNormal().y + state.getRay().getDirection().y;
            dir.z = dn * state.getNormal().z + state.getRay().getDirection().z;
            state.traceReflectionPhoton(new Ray(state.getPoint(), dir), power);
        }
    }

    public boolean update(ParameterList pl, SunflowAPI api) {
        return true;
    }
}

