/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class DirectionalLight
implements LightSource {
    private Vector3 dir;
    private Point3 sceneCenter;
    private Color power;
    private Color photonPower = new Color();
    private double distortion = 8.9E-5f;
    private int samples = 8;
    private float sceneRadius = 320.0f;
    OrthoNormalBasis onb;

    public DirectionalLight() {
        this.sceneCenter = new Point3(0.0f, 0.0f, 0.0f);
        this.dir = new Vector3(0.0f, 1.0f, 0.0f);
        this.power = Color.WHITE;
        this.onb = OrthoNormalBasis.makeFromW((Vector3)this.dir);
    }

    public boolean update(ParameterList pl, SunflowAPI api) {
        this.dir = pl.getVector("dir", this.dir);
        this.samples = pl.getInt("samples", 8);
        float radius = pl.getFloat("radius", 0.009459685f);
        this.distortion = 1.0 - Math.cos(radius);
        this.dir.normalize();
        this.onb = OrthoNormalBasis.makeFromW((Vector3)this.dir);
        this.power = pl.getColor("power", this.power);
        Color.mul((float)200.0f, (Color)this.power, (Color)this.photonPower);
        return true;
    }

    public int getNumSamples() {
        return this.samples;
    }

    public boolean isVisible(ShadingState state) {
        Vector3 n = state.getNormal();
        return (double)Vector3.dot((Vector3)this.dir, (Vector3)n) > 0.0;
    }

    public void getSamples(ShadingState state) {
        Vector3 lightDir = this.dir;
        int samples = state.getDiffuseDepth() > 0 ? 1 : this.getNumSamples();
        for (int i = 0; i < samples; ++i) {
            if (this.distortion != 0.0) {
                double h = 1.0 - state.getRandom(i, 0, samples) * this.distortion;
                double theta = 2.0 * state.getRandom(i, 1, samples) * Math.PI;
                double us = Math.sqrt(1.0 - h * h);
                float l1 = (float)(us * Math.cos(theta));
                float l2 = (float)(us * Math.sin(theta));
                float l3 = (float)h;
                lightDir = new Vector3(l1, l2, l3);
                this.onb.transform(lightDir);
            }
            LightSample dest = new LightSample();
            dest.setShadowRay(new Ray(state.getPoint(), lightDir));
            dest.getShadowRay().setMax(Float.MAX_VALUE);
            dest.setRadiance(this.power, this.power);
            dest.traceShadow(state);
        }
    }

    public void getPhoton(double randX1, double randY1, double randX2, double randY2, Point3 p, Vector3 dir, Color power) {
        Vector3 lightDir = dir;
        if (this.distortion != 0.0) {
            double h = 1.0 - randX1 * this.distortion;
            double theta = 2.0 * randY1 * Math.PI;
            double us = Math.sqrt(1.0 - h * h);
            float l1 = (float)(us * Math.cos(theta));
            float l2 = (float)(us * Math.sin(theta));
            float l3 = -((float)h);
            lightDir = new Vector3(l1, l2, l3);
            this.onb.transform(lightDir);
        }
        dir.set(lightDir);
        double phi = randX2 * 2.0 * Math.PI;
        double r = (double)this.sceneRadius * Math.sqrt(randY2);
        float p1 = (float)(r * Math.cos(phi));
        float p2 = (float)(r * Math.sin(phi));
        Vector3 position = new Vector3(p1, p2, this.sceneRadius);
        this.onb.transform(position);
        Point3.add((Point3)this.sceneCenter, (Vector3)position, (Point3)p);
        power.set(this.photonPower);
    }

    public boolean isAdaptive() {
        return false;
    }

    public float getPower() {
        return this.power.getLuminance();
    }

    public int getLowSamples() {
        return 1;
    }
}

