/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.camera;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;

public class TiledPinholeLens
implements CameraLens {
    private float au;
    private float av;
    private float aspect = 1.0f;
    private float fov = 90.0f;
    private int tilesX = 1;
    private int tilesY = 1;
    private int tileX = 0;
    private int tileY = 0;

    public TiledPinholeLens() {
        this.update();
    }

    public boolean update(ParameterList pl, SunflowAPI api) {
        this.fov = pl.getFloat("fov", this.fov);
        this.aspect = pl.getFloat("aspect", this.aspect);
        this.tilesX = pl.getInt("tilesX", 1);
        this.tilesY = pl.getInt("tilesY", 1);
        this.tileX = pl.getInt("tileX", 0);
        this.tileY = pl.getInt("tileY", 0);
        this.update();
        return true;
    }

    private void update() {
        this.au = (float)Math.tan(Math.toRadians(this.fov * 0.5f));
        this.av = this.au / this.aspect;
    }

    public Ray getRay(float x, float y, int imageX, int imageY, double lensX, double lensY, double time) {
        int imageWidth = imageX * this.tilesX;
        int imageHeight = imageY * this.tilesY;
        float du = -this.au + 2.0f * this.au * (x + (float)(this.tileX * imageX)) / ((float)imageWidth - 1.0f);
        float dv = -this.av + 2.0f * this.av * (y + (float)(this.tileY * imageY)) / ((float)imageHeight - 1.0f);
        return new Ray(0.0f, 0.0f, 0.0f, du, dv, -1.0f);
    }
}

