/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.batchrender;

import org.sunflow.core.Display;
import org.sunflow.image.Bitmap;
import org.sunflow.image.Color;

public class FileDisplay
implements Display {
    private Bitmap bitmap = null;
    private String filename;

    public FileDisplay(boolean saveImage) {
        this.filename = saveImage ? "output.png" : null;
    }

    public FileDisplay(String filename) {
        this.filename = filename == null ? "output.png" : filename;
    }

    public void imageBegin(int w, int h, int bucketSize) {
        if (this.bitmap == null || this.bitmap.getWidth() != w || this.bitmap.getHeight() != h) {
            this.bitmap = new Bitmap(w, h, this.filename == null || this.filename.endsWith(".hdr"));
        }
    }

    public void imagePrepare(int x, int y, int w, int h, int id) {
    }

    public void imageUpdate(int x, int y, int w, int h, Color[] data) {
        int index = 0;
        for (int j = 0; j < h; ++j) {
            int i = 0;
            while (i < w) {
                this.bitmap.setPixel(x + i, this.bitmap.getHeight() - 1 - (y + j), data[index]);
                ++i;
                ++index;
            }
        }
    }

    public void imageFill(int x, int y, int w, int h, Color c) {
        Color cg = c;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                this.bitmap.setPixel(x + i, this.bitmap.getHeight() - 1 - (y + j), cg);
            }
        }
    }

    public void imageEnd() {
        if (this.filename != null) {
            this.bitmap.save(this.filename);
        }
    }
}

