/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.softviewer.Imager;

public class OutlineImager
extends Imager {
    private final int BLACK = -16777216;
    private final int WHITE = -1;
    private final double EDGE = 0.02;
    private final int COL = 600;

    public void process(int[] pixels, double[] zBuf, int w, int h) {
        for (int i = 1; i < w - 2; ++i) {
            for (int j = 1; j < h - 2; ++j) {
                int pos = i + w * j;
                if (zBuf[pos] - zBuf[pos + 1] > 0.02) {
                    pixels[pos] = -1;
                    pixels[pos + 1] = -16777216;
                    pixels[pos + 2] = -16777216;
                } else if (-(zBuf[pos] - zBuf[pos + 1]) > 0.02) {
                    pixels[pos] = -16777216;
                    pixels[pos + 1] = -1;
                    pixels[pos + 2] = -1;
                }
                if (zBuf[pos] - zBuf[pos + w] > 0.02) {
                    pixels[pos] = -1;
                    pixels[pos + w] = -16777216;
                    pixels[pos + 2 * w] = -16777216;
                    continue;
                }
                if (!(-(zBuf[pos] - zBuf[pos + w]) > 0.02)) continue;
                pixels[pos - w] = -16777216;
                pixels[pos] = -16777216;
                pixels[pos + w] = -1;
            }
        }
    }
}

