/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.pick.PickSystem;
import de.jreality.soft.NewDoublePolygonRasterizer;
import de.jreality.soft.PickPerspective;
import de.jreality.soft.PickVisitor;
import de.jreality.soft.PolygonPipeline;
import java.util.List;

public class SoftPickSystem
implements PickSystem {
    private SceneGraphComponent root;
    private PolygonPipeline pipeline;
    private PickPerspective perspective = new PickPerspective();
    private NewDoublePolygonRasterizer rasterizer;
    private PickVisitor pickVisitor = new PickVisitor();
    private Transformation cameraWorld = new Transformation();

    public SoftPickSystem() {
        int[] pixels = new int[1];
        this.rasterizer = new NewDoublePolygonRasterizer(pixels, true, true, this.pickVisitor.getHitDetector());
        this.pipeline = new PolygonPipeline(this.rasterizer);
        this.pipeline.setPerspective(this.perspective);
        this.pickVisitor.setPipeline(this.pipeline);
    }

    public void setSceneRoot(SceneGraphComponent root) {
        this.root = root;
    }

    public List computePick(double[] from, double[] to) {
        if (to.length < 4 || to[3] == 0.0) {
            return this.computePickImpl(from, to, 1000.0);
        }
        double[] dir = new double[3];
        Pn.dehomogenize(from, from);
        Pn.dehomogenize(to, to);
        dir[0] = to[0] - from[0];
        dir[1] = to[1] - from[1];
        dir[2] = to[2] - from[2];
        return this.computePickImpl(from, dir, Rn.euclideanNorm(dir));
    }

    public List computePickImpl(double[] foot, double[] direction, double far) {
        this.rasterizer.setWindow(0, 1, 0, 1);
        this.rasterizer.setSize(1.0, 1.0);
        this.rasterizer.start();
        int wh = 200;
        int hh = 200;
        this.perspective.setWidth(2 * wh);
        this.perspective.setHeight(2 * hh);
        this.perspective.setPickPoint(wh, hh);
        this.rasterizer.clear();
        this.perspective.setFieldOfViewDeg(0.1);
        this.perspective.setNear(1.0);
        this.perspective.setFar(far);
        this.pickVisitor.getHitDetector().setNdcToCamera(this.perspective.getInverseMatrix(null));
        MatrixBuilder mb = MatrixBuilder.euclidean();
        mb.translate(foot[0], foot[1], foot[2]);
        mb.rotateFromTo(new double[]{0.0, 0.0, -1.0}, direction);
        this.pipeline.clearPipeline();
        double[] im = new double[16];
        Rn.inverse(im, mb.getMatrix().getArray());
        this.cameraWorld.setMatrix(im);
        this.pickVisitor.setInitialTransformation(this.cameraWorld);
        this.pickVisitor.traverse(this.root);
        this.pipeline.sortPolygons();
        this.pipeline.renderRemaining(this.rasterizer);
        this.rasterizer.stop();
        return this.pickVisitor.getHitDetector().getHitList();
    }

    private static void normalToEuler(double[] r) {
        double x = r[0];
        double y = r[1];
        double z = r[2];
        double xrot = 0.0;
        double zrot = 0.0;
        double yrot = 0.0;
        if (z * z + x * x - 1.0E-6 > 0.0) {
            xrot = Math.acos(y);
            yrot = Math.atan2(x, z);
        }
        r[0] = xrot;
        r[0] = yrot;
        r[0] = zrot;
    }
}

