/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.soft.DefaultPerspective;
import de.jreality.soft.DoubleRasterizer;
import de.jreality.soft.NewDoublePolygonRasterizer;
import de.jreality.soft.NewFloatPolygonRasterizer;
import de.jreality.soft.NewPolygonRasterizer;
import de.jreality.soft.PolygonPipeline;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.RenderTraversal;
import de.jreality.util.DefaultMatrixSupport;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;

public abstract class Renderer {
    protected Camera camera;
    protected int argbBackground;
    protected SceneGraphComponent root;
    private SceneGraphPath cameraPath;
    private Transformation cameraWorld = new Transformation();
    private PolygonPipeline pipeline;
    private PolygonRasterizer rasterizer;
    private RenderTraversal renderTraversal;

    Renderer(PolygonPipeline pipe, PolygonRasterizer ras) {
        this.pipeline = pipe;
        this.rasterizer = ras;
        this.renderTraversal = new RenderTraversal();
        this.renderTraversal.setPipeline(this.pipeline);
    }

    public void setBackgroundColor(int c) {
        this.argbBackground = c;
        this.rasterizer.setBackground(c);
    }

    public int getBackgroundColor() {
        return this.argbBackground;
    }

    public abstract void render();

    public abstract void update();

    void render(int width, int height) {
        Object o;
        Appearance a;
        this.rasterizer.setWindow(0, width, 0, height);
        this.rasterizer.setSize(width, height);
        this.pipeline.getPerspective().setWidth(width);
        this.pipeline.getPerspective().setHeight(height);
        Appearance appearance = a = this.root == null ? null : this.root.getAppearance();
        Color background = a != null ? ((o = a.getAttribute("backgroundColor")) instanceof Color ? (Color)o : Color.WHITE) : Color.WHITE;
        this.rasterizer.setBackground(background.getRGB());
        this.rasterizer.clear();
        if (this.root != null && this.camera != null) {
            DefaultPerspective p = (DefaultPerspective)this.pipeline.getPerspective();
            p.setFieldOfViewDeg(this.camera.getFieldOfView());
            p.setNear(this.camera.getNear());
            p.setFar(this.camera.getFar());
            DefaultMatrixSupport.getSharedInstance().restoreDefault(this.cameraWorld, true);
            this.cameraWorld.setMatrix(this.cameraPath.getMatrix(null));
            this.pipeline.clearPipeline();
            double[] im = new double[16];
            Rn.inverse(im, this.cameraWorld.getMatrix());
            this.cameraWorld.setMatrix(im);
            this.renderTraversal.setInitialTransformation(this.cameraWorld);
            this.renderTraversal.traverse(this.root);
        }
        this.pipeline.sortPolygons();
        this.pipeline.renderRemaining(this.rasterizer);
        this.rasterizer.stop();
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
        this.camera = p == null ? null : (Camera)p.getLastElement();
    }

    public SceneGraphComponent getSceneRoot() {
        return this.root;
    }

    public void setSceneRoot(SceneGraphComponent component) {
        this.root = component;
        if (this.root != null && this.camera != null) {
            List<SceneGraphPath> camPaths = SceneGraphUtility.getPathsBetween(this.root, this.camera);
            if (camPaths.size() > 0) {
                this.cameraPath = camPaths.get(0);
            } else {
                this.camera = null;
                this.cameraPath = null;
            }
        }
    }

    public static class ByteArrayDouble
    extends Renderer {
        final BufferedImage img;
        final Dimension d;
        final byte[] pixels;

        ByteArrayDouble(BufferedImage bi) {
            this(bi, new byte[3 * bi.getWidth() * bi.getHeight()]);
        }

        private ByteArrayDouble(BufferedImage bi, byte[] bBuffer) {
            this(bi, ByteArrayDouble.createRasterizer(bBuffer), bBuffer);
        }

        private ByteArrayDouble(BufferedImage bi, PolygonRasterizer r, byte[] bBuffer) {
            super(ByteArrayDouble.createPipeline(bi, r), r);
            this.d = new Dimension(bi.getWidth(), bi.getHeight());
            this.pixels = bBuffer;
            this.img = bi;
        }

        private static PolygonRasterizer createRasterizer(byte[] pixels) {
            return new DoubleRasterizer(pixels);
        }

        static PolygonPipeline createPipeline(BufferedImage bi, PolygonRasterizer r) {
            return new PolygonPipeline(r);
        }

        public void render() {
            this.render(this.d.width, this.d.height);
        }

        public void update() {
            this.img.getRaster().setDataElements(0, 0, this.d.width, this.d.height, this.pixels);
        }
    }

    public static class IntArrayFloat
    extends Renderer {
        final BufferedImage img;
        final Dimension d;
        final int[] pixels;

        IntArrayFloat(BufferedImage bi) {
            this(bi, new int[bi.getWidth() * bi.getHeight()]);
        }

        private IntArrayFloat(BufferedImage bi, int[] bBuffer) {
            this(bi, IntArrayFloat.createRasterizer(bBuffer), bBuffer);
        }

        private IntArrayFloat(BufferedImage bi, PolygonRasterizer r, int[] bBuffer) {
            super(IntArrayFloat.createPipeline(bi, r), r);
            this.d = new Dimension(bi.getWidth(), bi.getHeight());
            this.pixels = bBuffer;
            this.img = bi;
        }

        private static PolygonRasterizer createRasterizer(int[] pixels) {
            return new NewFloatPolygonRasterizer(pixels);
        }

        static PolygonPipeline createPipeline(BufferedImage bi, PolygonRasterizer r) {
            return new PolygonPipeline(r);
        }

        public void render() {
            this.render(this.d.width, this.d.height);
        }

        public void update() {
            this.img.getRaster().setDataElements(0, 0, this.d.width, this.d.height, this.pixels);
        }
    }

    public static class IntArrayDouble
    extends Renderer {
        final BufferedImage img;
        final Dimension d;
        final int[] pixels;

        IntArrayDouble(BufferedImage bi) {
            this(bi, new int[bi.getWidth() * bi.getHeight()]);
        }

        private IntArrayDouble(BufferedImage bi, int[] bBuffer) {
            this(bi, IntArrayDouble.createRasterizer(bBuffer), bBuffer);
        }

        private IntArrayDouble(BufferedImage bi, PolygonRasterizer r, int[] bBuffer) {
            super(IntArrayDouble.createPipeline(bi, r), r);
            this.d = new Dimension(bi.getWidth(), bi.getHeight());
            this.pixels = bBuffer;
            this.img = bi;
        }

        private static PolygonRasterizer createRasterizer(int[] pixels) {
            return new NewDoublePolygonRasterizer(pixels);
        }

        static PolygonPipeline createPipeline(BufferedImage bi, PolygonRasterizer r) {
            return new PolygonPipeline(r);
        }

        public void render() {
            this.render(this.d.width, this.d.height);
        }

        public void update() {
            this.img.getRaster().setDataElements(0, 0, this.d.width, this.d.height, this.pixels);
        }
    }

    public static class IntArray
    extends Renderer {
        final BufferedImage img;
        final Dimension d;
        final int[] pixels;

        IntArray(BufferedImage bi) {
            this(bi, new int[bi.getWidth() * bi.getHeight()]);
        }

        private IntArray(BufferedImage bi, int[] bBuffer) {
            this(bi, IntArray.createRasterizer(bBuffer), bBuffer);
        }

        private IntArray(BufferedImage bi, PolygonRasterizer r, int[] bBuffer) {
            super(IntArray.createPipeline(bi, r), r);
            this.d = new Dimension(bi.getWidth(), bi.getHeight());
            this.pixels = bBuffer;
            this.img = bi;
        }

        private static PolygonRasterizer createRasterizer(int[] pixels) {
            return new NewPolygonRasterizer(pixels);
        }

        static PolygonPipeline createPipeline(BufferedImage bi, PolygonRasterizer r) {
            return new PolygonPipeline(r);
        }

        public void render() {
            this.render(this.d.width, this.d.height);
        }

        public void update() {
            this.img.getRaster().setDataElements(0, 0, this.d.width, this.d.height, this.pixels);
        }
    }
}

