/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.soft.PolygonShader;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;

public final class Polygon {
    public static final int MAXPOLYVERTEX;
    public static final int SX = 0;
    public static final int SY = 1;
    public static final int SZ = 2;
    public static final int SW = 3;
    public static final int R = 4;
    public static final int G = 5;
    public static final int B = 6;
    public static final int A = 7;
    public static final int U = 8;
    public static final int V = 9;
    public static final int NX = 10;
    public static final int NY = 11;
    public static final int NZ = 12;
    public static final int VERTEX_LENGTH = 13;
    private double centerZ;
    protected int length;
    protected int[] vertices = new int[MAXPOLYVERTEX];
    private PolygonShader shader;

    public Polygon() {
        this.length = 0;
    }

    public Polygon(int l) {
        this.length = l;
    }

    public final double getCenterZ() {
        return this.centerZ;
    }

    final void setCenterZ(double d) {
        this.centerZ = d;
    }

    public final void computeCenterZ(double[] data) {
        this.centerZ = 0.0;
        for (int i = 0; i < this.length; ++i) {
            this.centerZ += data[this.vertices[i] + 2];
        }
        this.centerZ /= (double)this.length;
    }

    public final void computeMaxZ(double[] data) {
        this.centerZ = -1.7976931348623157E308;
        for (int i = 0; i < this.length; ++i) {
            double d = data[this.vertices[i] + 2] / data[this.vertices[i] + 3];
            if (!(d > this.centerZ)) continue;
            this.centerZ = d;
        }
    }

    public final void computeMinZ(double[] data) {
        this.centerZ = Double.MAX_VALUE;
        for (int i = 0; i < this.length; ++i) {
            double d = data[this.vertices[i] + 2] / data[this.vertices[i] + 3];
            if (!(d < this.centerZ)) continue;
            this.centerZ = d;
        }
    }

    public final double getMinZ(double[] data) {
        double minZ = Double.MAX_VALUE;
        for (int i = 0; i < this.length; ++i) {
            double d = data[this.vertices[i] + 2] / data[this.vertices[i] + 3];
            if (!(d < minZ)) continue;
            minZ = d;
        }
        return minZ;
    }

    public final double getMaxZ(double[] data) {
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < this.length; ++i) {
            double d = data[this.vertices[i] + 2] / data[this.vertices[i] + 3];
            if (!(d > maxZ)) continue;
            maxZ = d;
        }
        return maxZ;
    }

    public final PolygonShader getShader() {
        return this.shader;
    }

    public final void setShader(PolygonShader shader) {
        this.shader = shader;
    }

    public double[] getVertexNormal(int i, double[] data) {
        double[] x = new double[]{data[this.vertices[i] + 0] - data[this.vertices[(i - 1 + this.length) % this.length] + 0], data[this.vertices[i] + 1] - data[this.vertices[(i - 1 + this.length) % this.length] + 1], data[this.vertices[i] + 2] - data[this.vertices[(i - 1 + this.length) % this.length] + 2]};
        double[] y = new double[]{data[this.vertices[(i + 1) % this.length] + 0] - data[this.vertices[i] + 0], data[this.vertices[(i + 1) % this.length] + 1] - data[this.vertices[i] + 1], data[this.vertices[(i + 1) % this.length] + 2] - data[this.vertices[i] + 2]};
        double[] xxy = new double[3];
        Rn.crossProduct(xxy, x, y);
        double l = Rn.euclideanNorm(xxy);
        if (l != 0.0) {
            xxy[0] = xxy[0] / l;
            xxy[1] = xxy[1] / l;
            xxy[2] = xxy[2] / l;
        }
        return xxy;
    }

    public double[] getVertex(int i, double[] data) {
        double[] x = new double[]{data[this.vertices[i] + 0], data[this.vertices[i] + 1], data[this.vertices[i] + 2]};
        return x;
    }

    public void print(double[] vertexData) {
        for (int i = 0; i < this.length; ++i) {
            int pos = this.vertices[i];
            System.out.println("" + vertexData[pos + 0] + ", " + vertexData[pos + 1] + ", " + vertexData[pos + 2] + ", " + vertexData[pos + 3]);
        }
    }

    static {
        int pvInt = 14;
        try {
            String pv = Secure.getProperty("jreality.soft.maxpolyvertex");
            if (pv != null) {
                pvInt = Integer.parseInt(pv);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MAXPOLYVERTEX = pvInt;
        LoggingSystem.getLogger(Polygon.class).finer("Setting MAXPOLYVERTEX=" + MAXPOLYVERTEX);
    }
}

