/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Imager;

public class HatchImager
extends Imager {
    private final int BLACK = -16777216;
    private final int WHITE = -1;
    private final int EDGE = 300000000;

    public void process(int[] pixels, int[] zBuf, int w, int h) {
        for (int i = 1; i < w - 2; ++i) {
            for (int j = 1; j < h - 2; ++j) {
                int pos = i + w * j;
                if (zBuf[pos] - zBuf[pos + 1] > 300000000) {
                    pixels[pos - 1] = -1;
                    pixels[pos] = -1;
                    pixels[pos + 1] = -16777216;
                    pixels[pos + 2] = -16777216;
                } else if (-(zBuf[pos - 1] - zBuf[pos + 1]) > 300000000) {
                    pixels[pos - 1] = -16777216;
                    pixels[pos] = -16777216;
                    pixels[pos + 1] = -1;
                    pixels[pos + 2] = -1;
                }
                if (zBuf[pos] - zBuf[pos + w] > 300000000) {
                    pixels[pos - w] = -1;
                    pixels[pos] = -1;
                    pixels[pos + w] = -16777216;
                    pixels[pos + 2 * w] = -16777216;
                } else if (-(zBuf[pos] - zBuf[pos + w]) > 300000000) {
                    pixels[pos - w] = -16777216;
                    pixels[pos] = -16777216;
                    pixels[pos + w] = -1;
                    pixels[pos + 2 * w] = -1;
                }
                int value = ((pixels[pos] >> 16 & 0xFF) + (pixels[pos] >> 8 & 0xFF) + (pixels[pos] & 0xFF)) / 3;
                if (value > 80) {
                    pixels[pos] = -1;
                    continue;
                }
                int m = value > 20 ? 4 : (value > 5 ? 2 : 1);
                int iu = (i + j) / 4 % m;
                pixels[pos] = iu == 0 ? -16777216 : -1;
            }
        }
    }
}

