/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.soft.DefaultVertexShader;
import de.jreality.soft.Environment;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.SimpleTexture;
import de.jreality.soft.Texture;
import de.jreality.soft.VertexShader;

public class FlatPolygonShader
implements PolygonShader {
    private VertexShader vertexShader;
    private double[] v = new double[13];
    private boolean outline = false;
    private Texture texture;
    private double[] d1 = new double[3];
    private double[] d2 = new double[3];
    private double[] d3 = new double[3];

    public FlatPolygonShader() {
        this.vertexShader = new DefaultVertexShader();
    }

    public FlatPolygonShader(VertexShader v, boolean outline) {
        this.vertexShader = v;
        this.setOutline(outline);
    }

    public final void shadePolygon(Polygon p, double[] vertexData, Environment environment) {
        this.v[0] = 0.0;
        this.v[1] = 0.0;
        this.v[2] = 0.0;
        this.v[4] = 0.0;
        this.v[5] = 0.0;
        this.v[6] = 0.0;
        this.v[7] = 0.0;
        this.v[10] = 0.0;
        this.v[11] = 0.0;
        this.v[12] = 0.0;
        for (int i = 0; i < p.length; ++i) {
            int pos = p.vertices[i];
            this.v[0] = this.v[0] + vertexData[pos + 0];
            this.v[1] = this.v[1] + vertexData[pos + 1];
            this.v[2] = this.v[2] + vertexData[pos + 2];
            this.v[4] = this.v[4] + vertexData[pos + 4];
            this.v[5] = this.v[5] + vertexData[pos + 5];
            this.v[6] = this.v[6] + vertexData[pos + 6];
            this.v[7] = this.v[7] + vertexData[pos + 7];
        }
        this.v[0] = this.v[0] / (double)p.length;
        this.v[1] = this.v[1] / (double)p.length;
        this.v[2] = this.v[2] / (double)p.length;
        this.v[4] = this.v[4] / (double)p.length;
        this.v[5] = this.v[5] / (double)p.length;
        this.v[6] = this.v[6] / (double)p.length;
        this.v[7] = this.v[7] / (double)p.length;
        int pos = p.vertices[0];
        this.v[10] = vertexData[pos + 10];
        this.v[11] = vertexData[pos + 11];
        this.v[12] = vertexData[pos + 12];
        this.vertexShader.shadeVertex(this.v, 0, environment);
        for (int i = 0; i < p.length; ++i) {
            pos = p.vertices[i];
            vertexData[pos + 4] = this.v[4];
            vertexData[pos + 5] = this.v[5];
            vertexData[pos + 6] = this.v[6];
        }
    }

    public final VertexShader getVertexShader() {
        return this.vertexShader;
    }

    public final void setVertexShader(VertexShader s) {
        this.vertexShader = s;
    }

    public final boolean interpolateColor() {
        return false;
    }

    public boolean interpolateAlpha() {
        return false;
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public void setup(EffectiveAppearance eAppearance, String name) {
        this.outline = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "outline"), this.outline);
        this.vertexShader = ShaderLookup.getVertexShaderAttr(eAppearance, name, "vertexShader");
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eAppearance)) {
            this.texture = new SimpleTexture((Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eAppearance));
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void startGeometry(Geometry geom) {
        if (this.vertexShader != null) {
            this.vertexShader.startGeometry(geom);
        }
    }

    public boolean needsSorting() {
        return this.getVertexShader().getTransparency() != 0.0 || this.hasTexture() || this.interpolateAlpha();
    }
}

