/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.ClippingPlane;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.PointLight;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.soft.ClippingPlaneSoft;
import de.jreality.soft.DirectionalLightSoft;
import de.jreality.soft.SpotLightSoft;
import de.jreality.soft.VecMat;

public final class Environment
extends SceneGraphVisitor {
    double[] initialTrafo;
    double[] currentTrafo;
    private Transformation initialTransformation;
    protected Environment reclaimableSubcontext;
    private double[] matrix;
    private Globals globals;

    public Environment() {
        this.globals = new Globals();
    }

    protected Environment(Environment parentContext) {
        this.initializeFromParentContext(parentContext);
    }

    public final DirectionalLightSoft[] getDirectionalLights() {
        return this.globals.getDirectionalLights();
    }

    public final void addDirectionalLight(DirectionalLightSoft l) {
        this.globals.addDirectionalLight(l);
    }

    public final void removeDirectionalLight(DirectionalLightSoft l) {
        this.globals.removeDirectionalLight(l);
    }

    public final int getNumDirectionalLights() {
        return this.globals.getNumDirectionalLights();
    }

    public final SpotLightSoft[] getSpotLights() {
        return this.globals.getSpotLights();
    }

    public final void addSpotLight(SpotLightSoft l) {
        this.globals.addSpotLight(l);
    }

    public final void removeSpotLight(SpotLightSoft l) {
        this.globals.removeSpotLight(l);
    }

    public final int getNumSpotLights() {
        return this.globals.getNumSpotLights();
    }

    public final ClippingPlaneSoft[] getClippingPlanes() {
        return this.globals.getClippingPlanes();
    }

    public final void addClippingPlane(ClippingPlaneSoft c) {
        this.globals.addClippingPlane(c);
    }

    public final void removeClippingPlane(ClippingPlaneSoft c) {
        this.globals.removeClippingPlane(c);
    }

    public final int getNumClippingPlanes() {
        return this.globals.getNumClippingPlanes();
    }

    public final void removeAll() {
        this.globals.removeAll();
    }

    protected void initializeFromParentContext(Environment parentContext) {
        Environment p = parentContext;
        this.globals = parentContext.globals;
        this.initialTrafo = parentContext.currentTrafo;
        this.currentTrafo = parentContext.currentTrafo;
    }

    public void setInitialTransformation(Transformation initialTransformation) {
        this.initialTransformation = initialTransformation;
    }

    Environment subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new Environment(this);
        return this.reclaimableSubcontext;
    }

    public void traverse(SceneGraphComponent root) {
        this.removeAll();
        if (this.initialTrafo == null) {
            this.initialTrafo = new double[16];
        }
        if (this.initialTransformation != null) {
            this.initialTransformation.getMatrix(this.initialTrafo);
        } else {
            VecMat.assignIdentity(this.initialTrafo);
        }
        this.currentTrafo = this.initialTrafo;
        this.visit(root);
    }

    public void visit(SceneGraphComponent c) {
        c.childrenAccept(this.subContext());
    }

    public void visit(Transformation t) {
        if (this.initialTrafo == this.currentTrafo) {
            this.currentTrafo = new double[16];
        }
        VecMat.copyMatrix(this.initialTrafo, this.currentTrafo);
        VecMat.multiplyFromRight(this.currentTrafo, t.getMatrix());
    }

    public void visit(DirectionalLight l) {
        super.visit(l);
        if (!l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, 1.0, direction);
        VecMat.normalize(direction);
        this.addDirectionalLight(new DirectionalLightSoft(color[0], color[1], color[2], l.getIntensity(), direction));
    }

    public void visit(PointLight l) {
        super.visit(l);
        if (!l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, 1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, Math.PI, 0.0, l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }

    public void visit(SpotLight l) {
        if (!l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, l.getConeAngle(), l.getConeDeltaAngle(), l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }

    public void visit(ClippingPlane c) {
        super.visit(c);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.addClippingPlane(new ClippingPlaneSoft(direction, src));
    }

    public final double[] getMatrix() {
        return this.matrix;
    }

    public final void setMatrix(double[] matrix) {
        this.matrix = matrix;
    }

    private class Globals {
        private SpotLightSoft[] spotLights = new SpotLightSoft[0];
        private int numSpotLights;
        private ClippingPlaneSoft[] clippingPlanes = new ClippingPlaneSoft[0];
        private int numClippingPlanes;
        private int numDirectionalLights;
        private DirectionalLightSoft[] directionalLights = new DirectionalLightSoft[0];

        public final DirectionalLightSoft[] getDirectionalLights() {
            return this.directionalLights;
        }

        public final void addDirectionalLight(DirectionalLightSoft l) {
            if (l == null) {
                return;
            }
            if (this.numDirectionalLights == 0 || this.numDirectionalLights == this.directionalLights.length) {
                DirectionalLightSoft[] nl = new DirectionalLightSoft[this.numDirectionalLights + 5];
                if (this.numDirectionalLights != 0) {
                    System.arraycopy(this.directionalLights, 0, nl, 0, this.numDirectionalLights);
                }
                this.directionalLights = nl;
            }
            this.directionalLights[this.numDirectionalLights++] = l;
        }

        public final void removeDirectionalLight(DirectionalLightSoft l) {
            boolean on = false;
            for (int i = 0; i < this.numDirectionalLights - 1; ++i) {
                if (!on && this.directionalLights[i] == l) {
                    on = true;
                }
                if (!on) continue;
                this.directionalLights[i] = this.directionalLights[i + 1];
            }
            if (on) {
                this.directionalLights[this.numDirectionalLights - 1] = null;
                --this.numDirectionalLights;
            }
        }

        public final int getNumDirectionalLights() {
            return this.numDirectionalLights;
        }

        public final SpotLightSoft[] getSpotLights() {
            return this.spotLights;
        }

        public final void addSpotLight(SpotLightSoft l) {
            if (l == null) {
                return;
            }
            if (this.numSpotLights == 0 || this.numSpotLights == this.spotLights.length) {
                SpotLightSoft[] nl = new SpotLightSoft[this.numSpotLights + 5];
                if (this.numSpotLights != 0) {
                    System.arraycopy(this.spotLights, 0, nl, 0, this.numSpotLights);
                }
                this.spotLights = nl;
            }
            this.spotLights[this.numSpotLights++] = l;
        }

        public final void removeSpotLight(SpotLightSoft l) {
            boolean on = false;
            for (int i = 0; i < this.numSpotLights - 1; ++i) {
                if (!on && this.spotLights[i] == l) {
                    on = true;
                }
                if (!on) continue;
                this.spotLights[i] = this.spotLights[i + 1];
            }
            if (on) {
                this.spotLights[this.numSpotLights - 1] = null;
                --this.numSpotLights;
            }
        }

        public final int getNumSpotLights() {
            return this.numSpotLights;
        }

        public final ClippingPlaneSoft[] getClippingPlanes() {
            return this.clippingPlanes;
        }

        public final void addClippingPlane(ClippingPlaneSoft c) {
            if (c == null) {
                return;
            }
            if (this.numClippingPlanes == 0 || this.numClippingPlanes == this.clippingPlanes.length) {
                ClippingPlaneSoft[] nl = new ClippingPlaneSoft[this.numClippingPlanes + 5];
                if (this.numClippingPlanes != 0) {
                    System.arraycopy(this.clippingPlanes, 0, nl, 0, this.numClippingPlanes);
                }
                this.clippingPlanes = nl;
            }
            this.clippingPlanes[this.numClippingPlanes++] = c;
        }

        public final void removeClippingPlane(ClippingPlaneSoft c) {
            boolean on = false;
            for (int i = 0; i < this.numClippingPlanes - 1; ++i) {
                if (!on && this.clippingPlanes[i] == c) {
                    on = true;
                }
                if (!on) continue;
                this.clippingPlanes[i] = this.clippingPlanes[i + 1];
            }
            if (on) {
                this.clippingPlanes[this.numClippingPlanes - 1] = null;
                --this.numClippingPlanes;
            }
        }

        public final int getNumClippingPlanes() {
            return this.numClippingPlanes;
        }

        public final void removeAll() {
            int i;
            this.numSpotLights = 0;
            this.numDirectionalLights = 0;
            this.numClippingPlanes = 0;
            for (i = 0; i < this.spotLights.length; ++i) {
                this.spotLights[i] = null;
            }
            for (i = 0; i < this.directionalLights.length; ++i) {
                this.directionalLights[i] = null;
            }
            for (i = 0; i < this.clippingPlanes.length; ++i) {
                this.clippingPlanes[i] = null;
            }
        }
    }
}

