/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.ModularDoublePolygonRasterizer;
import java.util.Arrays;

public class DoubleRasterizerInt
extends ModularDoublePolygonRasterizer {
    private static final int OPAQUE = -16777216;
    protected double[] zBuffer;
    private int w = 0;
    private int h = 0;
    private int[] pixels;
    private int background;

    public DoubleRasterizerInt(int[] pixelBuffer) {
        this.pixels = pixelBuffer;
    }

    protected final void setPixel(int x, int y, double z, double red, double green, double blue, double transparency) {
        int pos = x + this.w * y;
        if (z > this.zBuffer[pos]) {
            return;
        }
        if (transparency == 0.0) {
            this.pixels[pos] = 0xFF000000 | ((int)red << 16) + ((int)green << 8) + (int)blue;
        } else {
            int trans = (int)(255.0 * transparency);
            int sample = this.pixels[pos];
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            int r = ((int)red * 255 + trans * sr) * 257 & 0xFF0000;
            int g = ((int)green * 255 + trans * sg) * 257 >> 8 & 0xFF00;
            int b = ((int)blue * 255 + trans * sb) * 257 >> 16;
            this.pixels[pos] = 0xFF000000 | r | g | b;
        }
        this.zBuffer[pos] = z;
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public void clear() {
        Arrays.fill(this.zBuffer, Double.MAX_VALUE);
        Arrays.fill(this.pixels, this.background);
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        super.setWindow(xmin, xmax, ymin, ymax);
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new double[numPx];
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

